/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.transform.MetricDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, MetricDefinition> {
    private final String name;
    private final String regex;

    private MetricDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.regex = builder.regex;
    }

    public String name() {
        return this.name;
    }

    public String regex() {
        return this.regex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.regex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.regex(), other.regex());
    }

    public String toString() {
        return ToString.builder((String)"MetricDefinition").add("Name", (Object)this.name()).add("Regex", (Object)this.regex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Regex": {
                return Optional.ofNullable(clazz.cast(this.regex()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String regex;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDefinition model) {
            this.name(model.name);
            this.regex(model.regex);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegex() {
            return this.regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        public MetricDefinition build() {
            return new MetricDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricDefinition> {
        public Builder name(String var1);

        public Builder regex(String var1);
    }
}

