/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotebookInstanceLifecycleConfigsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListNotebookInstanceLifecycleConfigsResponse> {
    private final String nextToken;
    private final List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs;

    private ListNotebookInstanceLifecycleConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notebookInstanceLifecycleConfigs = builder.notebookInstanceLifecycleConfigs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs() {
        return this.notebookInstanceLifecycleConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceLifecycleConfigs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookInstanceLifecycleConfigsResponse)) {
            return false;
        }
        ListNotebookInstanceLifecycleConfigsResponse other = (ListNotebookInstanceLifecycleConfigsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.notebookInstanceLifecycleConfigs(), other.notebookInstanceLifecycleConfigs());
    }

    public String toString() {
        return ToString.builder((String)"ListNotebookInstanceLifecycleConfigsResponse").add("NextToken", (Object)this.nextToken()).add("NotebookInstanceLifecycleConfigs", this.notebookInstanceLifecycleConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NotebookInstanceLifecycleConfigs": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceLifecycleConfigs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookInstanceLifecycleConfigsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.notebookInstanceLifecycleConfigs(model.notebookInstanceLifecycleConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<NotebookInstanceLifecycleConfigSummary.Builder> getNotebookInstanceLifecycleConfigs() {
            return this.notebookInstanceLifecycleConfigs != null ? (Collection)this.notebookInstanceLifecycleConfigs.stream().map(NotebookInstanceLifecycleConfigSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigs(Collection<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs) {
            this.notebookInstanceLifecycleConfigs = NotebookInstanceLifecycleConfigSummaryListCopier.copy(notebookInstanceLifecycleConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstanceLifecycleConfigs(NotebookInstanceLifecycleConfigSummary ... notebookInstanceLifecycleConfigs) {
            this.notebookInstanceLifecycleConfigs(Arrays.asList(notebookInstanceLifecycleConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstanceLifecycleConfigs(Consumer<NotebookInstanceLifecycleConfigSummary.Builder> ... notebookInstanceLifecycleConfigs) {
            this.notebookInstanceLifecycleConfigs(Stream.of(notebookInstanceLifecycleConfigs).map(c -> (NotebookInstanceLifecycleConfigSummary)((NotebookInstanceLifecycleConfigSummary.Builder)NotebookInstanceLifecycleConfigSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigs(Collection<NotebookInstanceLifecycleConfigSummary.BuilderImpl> notebookInstanceLifecycleConfigs) {
            this.notebookInstanceLifecycleConfigs = NotebookInstanceLifecycleConfigSummaryListCopier.copyFromBuilder(notebookInstanceLifecycleConfigs);
        }

        @Override
        public ListNotebookInstanceLifecycleConfigsResponse build() {
            return new ListNotebookInstanceLifecycleConfigsResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, ListNotebookInstanceLifecycleConfigsResponse> {
        public Builder nextToken(String var1);

        public Builder notebookInstanceLifecycleConfigs(Collection<NotebookInstanceLifecycleConfigSummary> var1);

        public Builder notebookInstanceLifecycleConfigs(NotebookInstanceLifecycleConfigSummary ... var1);

        public Builder notebookInstanceLifecycleConfigs(Consumer<NotebookInstanceLifecycleConfigSummary.Builder> ... var1);
    }
}

