/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType;
import software.amazon.awssdk.services.sagemaker.transform.HyperParameterTuningJobObjectiveMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTuningJobObjective
implements StructuredPojo,
ToCopyableBuilder<Builder, HyperParameterTuningJobObjective> {
    private final String type;
    private final String metricName;

    private HyperParameterTuningJobObjective(BuilderImpl builder) {
        this.type = builder.type;
        this.metricName = builder.metricName;
    }

    public HyperParameterTuningJobObjectiveType type() {
        return HyperParameterTuningJobObjectiveType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String metricName() {
        return this.metricName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobObjective)) {
            return false;
        }
        HyperParameterTuningJobObjective other = (HyperParameterTuningJobObjective)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.metricName(), other.metricName());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterTuningJobObjective").add("Type", (Object)this.typeAsString()).add("MetricName", (Object)this.metricName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HyperParameterTuningJobObjectiveMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String metricName;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobObjective model) {
            this.type(model.type);
            this.metricName(model.metricName);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HyperParameterTuningJobObjectiveType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public HyperParameterTuningJobObjective build() {
            return new HyperParameterTuningJobObjective(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HyperParameterTuningJobObjective> {
        public Builder type(String var1);

        public Builder type(HyperParameterTuningJobObjectiveType var1);

        public Builder metricName(String var1);
    }
}

