/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.services.sagemaker.transform.HyperParameterTrainingJobSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTrainingJobSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, HyperParameterTrainingJobSummary> {
    private final String trainingJobName;
    private final String trainingJobArn;
    private final Instant creationTime;
    private final Instant trainingStartTime;
    private final Instant trainingEndTime;
    private final String trainingJobStatus;
    private final Map<String, String> tunedHyperParameters;
    private final String failureReason;
    private final FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric;
    private final String objectiveStatus;

    private HyperParameterTrainingJobSummary(BuilderImpl builder) {
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.creationTime = builder.creationTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.trainingJobStatus = builder.trainingJobStatus;
        this.tunedHyperParameters = builder.tunedHyperParameters;
        this.failureReason = builder.failureReason;
        this.finalHyperParameterTuningJobObjectiveMetric = builder.finalHyperParameterTuningJobObjectiveMetric;
        this.objectiveStatus = builder.objectiveStatus;
    }

    public String trainingJobName() {
        return this.trainingJobName;
    }

    public String trainingJobArn() {
        return this.trainingJobArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant trainingStartTime() {
        return this.trainingStartTime;
    }

    public Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(this.trainingJobStatus);
    }

    public String trainingJobStatusAsString() {
        return this.trainingJobStatus;
    }

    public Map<String, String> tunedHyperParameters() {
        return this.tunedHyperParameters;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric() {
        return this.finalHyperParameterTuningJobObjectiveMetric;
    }

    public ObjectiveStatus objectiveStatus() {
        return ObjectiveStatus.fromValue(this.objectiveStatus);
    }

    public String objectiveStatusAsString() {
        return this.objectiveStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunedHyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalHyperParameterTuningJobObjectiveMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectiveStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTrainingJobSummary)) {
            return false;
        }
        HyperParameterTrainingJobSummary other = (HyperParameterTrainingJobSummary)obj;
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.trainingJobArn(), other.trainingJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.trainingStartTime(), other.trainingStartTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.trainingJobStatusAsString(), other.trainingJobStatusAsString()) && Objects.equals(this.tunedHyperParameters(), other.tunedHyperParameters()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.finalHyperParameterTuningJobObjectiveMetric(), other.finalHyperParameterTuningJobObjectiveMetric()) && Objects.equals(this.objectiveStatusAsString(), other.objectiveStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterTrainingJobSummary").add("TrainingJobName", (Object)this.trainingJobName()).add("TrainingJobArn", (Object)this.trainingJobArn()).add("CreationTime", (Object)this.creationTime()).add("TrainingStartTime", (Object)this.trainingStartTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("TrainingJobStatus", (Object)this.trainingJobStatusAsString()).add("TunedHyperParameters", this.tunedHyperParameters()).add("FailureReason", (Object)this.failureReason()).add("FinalHyperParameterTuningJobObjectiveMetric", (Object)this.finalHyperParameterTuningJobObjectiveMetric()).add("ObjectiveStatus", (Object)this.objectiveStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "TrainingJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainingJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TrainingStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingStartTime()));
            }
            case "TrainingEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTime()));
            }
            case "TrainingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusAsString()));
            }
            case "TunedHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.tunedHyperParameters()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "FinalHyperParameterTuningJobObjectiveMetric": {
                return Optional.ofNullable(clazz.cast(this.finalHyperParameterTuningJobObjectiveMetric()));
            }
            case "ObjectiveStatus": {
                return Optional.ofNullable(clazz.cast(this.objectiveStatusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HyperParameterTrainingJobSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingJobName;
        private String trainingJobArn;
        private Instant creationTime;
        private Instant trainingStartTime;
        private Instant trainingEndTime;
        private String trainingJobStatus;
        private Map<String, String> tunedHyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private String failureReason;
        private FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric;
        private String objectiveStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTrainingJobSummary model) {
            this.trainingJobName(model.trainingJobName);
            this.trainingJobArn(model.trainingJobArn);
            this.creationTime(model.creationTime);
            this.trainingStartTime(model.trainingStartTime);
            this.trainingEndTime(model.trainingEndTime);
            this.trainingJobStatus(model.trainingJobStatus);
            this.tunedHyperParameters(model.tunedHyperParameters);
            this.failureReason(model.failureReason);
            this.finalHyperParameterTuningJobObjectiveMetric(model.finalHyperParameterTuningJobObjectiveMetric);
            this.objectiveStatus(model.objectiveStatus);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final String getTrainingJobArn() {
            return this.trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTrainingStartTime() {
            return this.trainingStartTime;
        }

        @Override
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final String getTrainingJobStatus() {
            return this.trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus.toString());
            return this;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        public final Map<String, String> getTunedHyperParameters() {
            return this.tunedHyperParameters;
        }

        @Override
        public final Builder tunedHyperParameters(Map<String, String> tunedHyperParameters) {
            this.tunedHyperParameters = HyperParametersCopier.copy(tunedHyperParameters);
            return this;
        }

        public final void setTunedHyperParameters(Map<String, String> tunedHyperParameters) {
            this.tunedHyperParameters = HyperParametersCopier.copy(tunedHyperParameters);
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final FinalHyperParameterTuningJobObjectiveMetric.Builder getFinalHyperParameterTuningJobObjectiveMetric() {
            return this.finalHyperParameterTuningJobObjectiveMetric != null ? this.finalHyperParameterTuningJobObjectiveMetric.toBuilder() : null;
        }

        @Override
        public final Builder finalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric finalHyperParameterTuningJobObjectiveMetric) {
            this.finalHyperParameterTuningJobObjectiveMetric = finalHyperParameterTuningJobObjectiveMetric;
            return this;
        }

        public final void setFinalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric.BuilderImpl finalHyperParameterTuningJobObjectiveMetric) {
            this.finalHyperParameterTuningJobObjectiveMetric = finalHyperParameterTuningJobObjectiveMetric != null ? finalHyperParameterTuningJobObjectiveMetric.build() : null;
        }

        public final String getObjectiveStatus() {
            return this.objectiveStatus;
        }

        @Override
        public final Builder objectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
            return this;
        }

        @Override
        public final Builder objectiveStatus(ObjectiveStatus objectiveStatus) {
            this.objectiveStatus(objectiveStatus.toString());
            return this;
        }

        public final void setObjectiveStatus(String objectiveStatus) {
            this.objectiveStatus = objectiveStatus;
        }

        public HyperParameterTrainingJobSummary build() {
            return new HyperParameterTrainingJobSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HyperParameterTrainingJobSummary> {
        public Builder trainingJobName(String var1);

        public Builder trainingJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder trainingStartTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder trainingJobStatus(String var1);

        public Builder trainingJobStatus(TrainingJobStatus var1);

        public Builder tunedHyperParameters(Map<String, String> var1);

        public Builder failureReason(String var1);

        public Builder finalHyperParameterTuningJobObjectiveMetric(FinalHyperParameterTuningJobObjectiveMetric var1);

        default public Builder finalHyperParameterTuningJobObjectiveMetric(Consumer<FinalHyperParameterTuningJobObjectiveMetric.Builder> finalHyperParameterTuningJobObjectiveMetric) {
            return this.finalHyperParameterTuningJobObjectiveMetric((FinalHyperParameterTuningJobObjectiveMetric)((FinalHyperParameterTuningJobObjectiveMetric.Builder)FinalHyperParameterTuningJobObjectiveMetric.builder().applyMutation(finalHyperParameterTuningJobObjectiveMetric)).build());
        }

        public Builder objectiveStatus(String var1);

        public Builder objectiveStatus(ObjectiveStatus var1);
    }
}

