/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectiveType;
import software.amazon.awssdk.services.sagemaker.transform.FinalHyperParameterTuningJobObjectiveMetricMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FinalHyperParameterTuningJobObjectiveMetric
implements StructuredPojo,
ToCopyableBuilder<Builder, FinalHyperParameterTuningJobObjectiveMetric> {
    private final String type;
    private final String metricName;
    private final Float value;

    private FinalHyperParameterTuningJobObjectiveMetric(BuilderImpl builder) {
        this.type = builder.type;
        this.metricName = builder.metricName;
        this.value = builder.value;
    }

    public HyperParameterTuningJobObjectiveType type() {
        return HyperParameterTuningJobObjectiveType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String metricName() {
        return this.metricName;
    }

    public Float value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FinalHyperParameterTuningJobObjectiveMetric)) {
            return false;
        }
        FinalHyperParameterTuningJobObjectiveMetric other = (FinalHyperParameterTuningJobObjectiveMetric)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"FinalHyperParameterTuningJobObjectiveMetric").add("Type", (Object)this.typeAsString()).add("MetricName", (Object)this.metricName()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FinalHyperParameterTuningJobObjectiveMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String metricName;
        private Float value;

        private BuilderImpl() {
        }

        private BuilderImpl(FinalHyperParameterTuningJobObjectiveMetric model) {
            this.type(model.type);
            this.metricName(model.metricName);
            this.value(model.value);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HyperParameterTuningJobObjectiveType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Float getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Float value) {
            this.value = value;
            return this;
        }

        public final void setValue(Float value) {
            this.value = value;
        }

        public FinalHyperParameterTuningJobObjectiveMetric build() {
            return new FinalHyperParameterTuningJobObjectiveMetric(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FinalHyperParameterTuningJobObjectiveMetric> {
        public Builder type(String var1);

        public Builder type(HyperParameterTuningJobObjectiveType var1);

        public Builder metricName(String var1);

        public Builder value(Float var1);
    }
}

