/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.transform.EndpointConfigSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointConfigSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointConfigSummary> {
    private final String endpointConfigName;
    private final String endpointConfigArn;
    private final Instant creationTime;

    private EndpointConfigSummary(BuilderImpl builder) {
        this.endpointConfigName = builder.endpointConfigName;
        this.endpointConfigArn = builder.endpointConfigArn;
        this.creationTime = builder.creationTime;
    }

    public String endpointConfigName() {
        return this.endpointConfigName;
    }

    public String endpointConfigArn() {
        return this.endpointConfigArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfigSummary)) {
            return false;
        }
        EndpointConfigSummary other = (EndpointConfigSummary)obj;
        return Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && Objects.equals(this.endpointConfigArn(), other.endpointConfigArn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"EndpointConfigSummary").add("EndpointConfigName", (Object)this.endpointConfigName()).add("EndpointConfigArn", (Object)this.endpointConfigArn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "EndpointConfigArn": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointConfigSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointConfigName;
        private String endpointConfigArn;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfigSummary model) {
            this.endpointConfigName(model.endpointConfigName);
            this.endpointConfigArn(model.endpointConfigArn);
            this.creationTime(model.creationTime);
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        public final String getEndpointConfigArn() {
            return this.endpointConfigArn;
        }

        @Override
        public final Builder endpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
            return this;
        }

        public final void setEndpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public EndpointConfigSummary build() {
            return new EndpointConfigSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointConfigSummary> {
        public Builder endpointConfigName(String var1);

        public Builder endpointConfigArn(String var1);

        public Builder creationTime(Instant var1);
    }
}

