/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.BatchStrategy;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TransformEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformInput;
import software.amazon.awssdk.services.sagemaker.model.TransformJobStatus;
import software.amazon.awssdk.services.sagemaker.model.TransformOutput;
import software.amazon.awssdk.services.sagemaker.model.TransformResources;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransformJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeTransformJobResponse> {
    private final String transformJobName;
    private final String transformJobArn;
    private final String transformJobStatus;
    private final String failureReason;
    private final String modelName;
    private final Integer maxConcurrentTransforms;
    private final Integer maxPayloadInMB;
    private final String batchStrategy;
    private final Map<String, String> environment;
    private final TransformInput transformInput;
    private final TransformOutput transformOutput;
    private final TransformResources transformResources;
    private final Instant creationTime;
    private final Instant transformStartTime;
    private final Instant transformEndTime;

    private DescribeTransformJobResponse(BuilderImpl builder) {
        super(builder);
        this.transformJobName = builder.transformJobName;
        this.transformJobArn = builder.transformJobArn;
        this.transformJobStatus = builder.transformJobStatus;
        this.failureReason = builder.failureReason;
        this.modelName = builder.modelName;
        this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
        this.maxPayloadInMB = builder.maxPayloadInMB;
        this.batchStrategy = builder.batchStrategy;
        this.environment = builder.environment;
        this.transformInput = builder.transformInput;
        this.transformOutput = builder.transformOutput;
        this.transformResources = builder.transformResources;
        this.creationTime = builder.creationTime;
        this.transformStartTime = builder.transformStartTime;
        this.transformEndTime = builder.transformEndTime;
    }

    public String transformJobName() {
        return this.transformJobName;
    }

    public String transformJobArn() {
        return this.transformJobArn;
    }

    public TransformJobStatus transformJobStatus() {
        return TransformJobStatus.fromValue(this.transformJobStatus);
    }

    public String transformJobStatusAsString() {
        return this.transformJobStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String modelName() {
        return this.modelName;
    }

    public Integer maxConcurrentTransforms() {
        return this.maxConcurrentTransforms;
    }

    public Integer maxPayloadInMB() {
        return this.maxPayloadInMB;
    }

    public BatchStrategy batchStrategy() {
        return BatchStrategy.fromValue(this.batchStrategy);
    }

    public String batchStrategyAsString() {
        return this.batchStrategy;
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public TransformInput transformInput() {
        return this.transformInput;
    }

    public TransformOutput transformOutput() {
        return this.transformOutput;
    }

    public TransformResources transformResources() {
        return this.transformResources;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant transformStartTime() {
        return this.transformStartTime;
    }

    public Instant transformEndTime() {
        return this.transformEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentTransforms());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPayloadInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformEndTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransformJobResponse)) {
            return false;
        }
        DescribeTransformJobResponse other = (DescribeTransformJobResponse)((Object)obj);
        return Objects.equals(this.transformJobName(), other.transformJobName()) && Objects.equals(this.transformJobArn(), other.transformJobArn()) && Objects.equals(this.transformJobStatusAsString(), other.transformJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.maxConcurrentTransforms(), other.maxConcurrentTransforms()) && Objects.equals(this.maxPayloadInMB(), other.maxPayloadInMB()) && Objects.equals(this.batchStrategyAsString(), other.batchStrategyAsString()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.transformInput(), other.transformInput()) && Objects.equals(this.transformOutput(), other.transformOutput()) && Objects.equals(this.transformResources(), other.transformResources()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.transformStartTime(), other.transformStartTime()) && Objects.equals(this.transformEndTime(), other.transformEndTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTransformJobResponse").add("TransformJobName", (Object)this.transformJobName()).add("TransformJobArn", (Object)this.transformJobArn()).add("TransformJobStatus", (Object)this.transformJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("ModelName", (Object)this.modelName()).add("MaxConcurrentTransforms", (Object)this.maxConcurrentTransforms()).add("MaxPayloadInMB", (Object)this.maxPayloadInMB()).add("BatchStrategy", (Object)this.batchStrategyAsString()).add("Environment", this.environment()).add("TransformInput", (Object)this.transformInput()).add("TransformOutput", (Object)this.transformOutput()).add("TransformResources", (Object)this.transformResources()).add("CreationTime", (Object)this.creationTime()).add("TransformStartTime", (Object)this.transformStartTime()).add("TransformEndTime", (Object)this.transformEndTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformJobName": {
                return Optional.ofNullable(clazz.cast(this.transformJobName()));
            }
            case "TransformJobArn": {
                return Optional.ofNullable(clazz.cast(this.transformJobArn()));
            }
            case "TransformJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transformJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "MaxConcurrentTransforms": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentTransforms()));
            }
            case "MaxPayloadInMB": {
                return Optional.ofNullable(clazz.cast(this.maxPayloadInMB()));
            }
            case "BatchStrategy": {
                return Optional.ofNullable(clazz.cast(this.batchStrategyAsString()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "TransformInput": {
                return Optional.ofNullable(clazz.cast(this.transformInput()));
            }
            case "TransformOutput": {
                return Optional.ofNullable(clazz.cast(this.transformOutput()));
            }
            case "TransformResources": {
                return Optional.ofNullable(clazz.cast(this.transformResources()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TransformStartTime": {
                return Optional.ofNullable(clazz.cast(this.transformStartTime()));
            }
            case "TransformEndTime": {
                return Optional.ofNullable(clazz.cast(this.transformEndTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String transformJobName;
        private String transformJobArn;
        private String transformJobStatus;
        private String failureReason;
        private String modelName;
        private Integer maxConcurrentTransforms;
        private Integer maxPayloadInMB;
        private String batchStrategy;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private TransformInput transformInput;
        private TransformOutput transformOutput;
        private TransformResources transformResources;
        private Instant creationTime;
        private Instant transformStartTime;
        private Instant transformEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransformJobResponse model) {
            super(model);
            this.transformJobName(model.transformJobName);
            this.transformJobArn(model.transformJobArn);
            this.transformJobStatus(model.transformJobStatus);
            this.failureReason(model.failureReason);
            this.modelName(model.modelName);
            this.maxConcurrentTransforms(model.maxConcurrentTransforms);
            this.maxPayloadInMB(model.maxPayloadInMB);
            this.batchStrategy(model.batchStrategy);
            this.environment(model.environment);
            this.transformInput(model.transformInput);
            this.transformOutput(model.transformOutput);
            this.transformResources(model.transformResources);
            this.creationTime(model.creationTime);
            this.transformStartTime(model.transformStartTime);
            this.transformEndTime(model.transformEndTime);
        }

        public final String getTransformJobName() {
            return this.transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        public final String getTransformJobArn() {
            return this.transformJobArn;
        }

        @Override
        public final Builder transformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
            return this;
        }

        public final void setTransformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
        }

        public final String getTransformJobStatus() {
            return this.transformJobStatus;
        }

        @Override
        public final Builder transformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
            return this;
        }

        @Override
        public final Builder transformJobStatus(TransformJobStatus transformJobStatus) {
            this.transformJobStatus(transformJobStatus.toString());
            return this;
        }

        public final void setTransformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Integer getMaxConcurrentTransforms() {
            return this.maxConcurrentTransforms;
        }

        @Override
        public final Builder maxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        public final void setMaxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
        }

        public final Integer getMaxPayloadInMB() {
            return this.maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        public final String getBatchStrategy() {
            return this.batchStrategy;
        }

        @Override
        public final Builder batchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Override
        public final Builder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy(batchStrategy.toString());
            return this;
        }

        public final void setBatchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
        }

        public final Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
        }

        public final TransformInput.Builder getTransformInput() {
            return this.transformInput != null ? this.transformInput.toBuilder() : null;
        }

        @Override
        public final Builder transformInput(TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        public final void setTransformInput(TransformInput.BuilderImpl transformInput) {
            this.transformInput = transformInput != null ? transformInput.build() : null;
        }

        public final TransformOutput.Builder getTransformOutput() {
            return this.transformOutput != null ? this.transformOutput.toBuilder() : null;
        }

        @Override
        public final Builder transformOutput(TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        public final void setTransformOutput(TransformOutput.BuilderImpl transformOutput) {
            this.transformOutput = transformOutput != null ? transformOutput.build() : null;
        }

        public final TransformResources.Builder getTransformResources() {
            return this.transformResources != null ? this.transformResources.toBuilder() : null;
        }

        @Override
        public final Builder transformResources(TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        public final void setTransformResources(TransformResources.BuilderImpl transformResources) {
            this.transformResources = transformResources != null ? transformResources.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTransformStartTime() {
            return this.transformStartTime;
        }

        @Override
        public final Builder transformStartTime(Instant transformStartTime) {
            this.transformStartTime = transformStartTime;
            return this;
        }

        public final void setTransformStartTime(Instant transformStartTime) {
            this.transformStartTime = transformStartTime;
        }

        public final Instant getTransformEndTime() {
            return this.transformEndTime;
        }

        @Override
        public final Builder transformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
            return this;
        }

        public final void setTransformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
        }

        @Override
        public DescribeTransformJobResponse build() {
            return new DescribeTransformJobResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, DescribeTransformJobResponse> {
        public Builder transformJobName(String var1);

        public Builder transformJobArn(String var1);

        public Builder transformJobStatus(String var1);

        public Builder transformJobStatus(TransformJobStatus var1);

        public Builder failureReason(String var1);

        public Builder modelName(String var1);

        public Builder maxConcurrentTransforms(Integer var1);

        public Builder maxPayloadInMB(Integer var1);

        public Builder batchStrategy(String var1);

        public Builder batchStrategy(BatchStrategy var1);

        public Builder environment(Map<String, String> var1);

        public Builder transformInput(TransformInput var1);

        default public Builder transformInput(Consumer<TransformInput.Builder> transformInput) {
            return this.transformInput((TransformInput)((TransformInput.Builder)TransformInput.builder().applyMutation(transformInput)).build());
        }

        public Builder transformOutput(TransformOutput var1);

        default public Builder transformOutput(Consumer<TransformOutput.Builder> transformOutput) {
            return this.transformOutput((TransformOutput)((TransformOutput.Builder)TransformOutput.builder().applyMutation(transformOutput)).build());
        }

        public Builder transformResources(TransformResources var1);

        default public Builder transformResources(Consumer<TransformResources.Builder> transformResources) {
            return this.transformResources((TransformResources)((TransformResources.Builder)TransformResources.builder().applyMutation(transformResources)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder transformStartTime(Instant var1);

        public Builder transformEndTime(Instant var1);
    }
}

