/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.InputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelArtifacts;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatus;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrainingJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeTrainingJobResponse> {
    private final String trainingJobName;
    private final String trainingJobArn;
    private final String tuningJobArn;
    private final ModelArtifacts modelArtifacts;
    private final String trainingJobStatus;
    private final String secondaryStatus;
    private final String failureReason;
    private final Map<String, String> hyperParameters;
    private final AlgorithmSpecification algorithmSpecification;
    private final String roleArn;
    private final List<Channel> inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final ResourceConfig resourceConfig;
    private final VpcConfig vpcConfig;
    private final StoppingCondition stoppingCondition;
    private final Instant creationTime;
    private final Instant trainingStartTime;
    private final Instant trainingEndTime;
    private final Instant lastModifiedTime;
    private final List<SecondaryStatusTransition> secondaryStatusTransitions;

    private DescribeTrainingJobResponse(BuilderImpl builder) {
        super(builder);
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.tuningJobArn = builder.tuningJobArn;
        this.modelArtifacts = builder.modelArtifacts;
        this.trainingJobStatus = builder.trainingJobStatus;
        this.secondaryStatus = builder.secondaryStatus;
        this.failureReason = builder.failureReason;
        this.hyperParameters = builder.hyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.creationTime = builder.creationTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.secondaryStatusTransitions = builder.secondaryStatusTransitions;
    }

    public String trainingJobName() {
        return this.trainingJobName;
    }

    public String trainingJobArn() {
        return this.trainingJobArn;
    }

    public String tuningJobArn() {
        return this.tuningJobArn;
    }

    public ModelArtifacts modelArtifacts() {
        return this.modelArtifacts;
    }

    public TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(this.trainingJobStatus);
    }

    public String trainingJobStatusAsString() {
        return this.trainingJobStatus;
    }

    public SecondaryStatus secondaryStatus() {
        return SecondaryStatus.fromValue(this.secondaryStatus);
    }

    public String secondaryStatusAsString() {
        return this.secondaryStatus;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public AlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<Channel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant trainingStartTime() {
        return this.trainingStartTime;
    }

    public Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public List<SecondaryStatusTransition> secondaryStatusTransitions() {
        return this.secondaryStatusTransitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryStatusTransitions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrainingJobResponse)) {
            return false;
        }
        DescribeTrainingJobResponse other = (DescribeTrainingJobResponse)((Object)obj);
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.trainingJobArn(), other.trainingJobArn()) && Objects.equals(this.tuningJobArn(), other.tuningJobArn()) && Objects.equals(this.modelArtifacts(), other.modelArtifacts()) && Objects.equals(this.trainingJobStatusAsString(), other.trainingJobStatusAsString()) && Objects.equals(this.secondaryStatusAsString(), other.secondaryStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.trainingStartTime(), other.trainingStartTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.secondaryStatusTransitions(), other.secondaryStatusTransitions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrainingJobResponse").add("TrainingJobName", (Object)this.trainingJobName()).add("TrainingJobArn", (Object)this.trainingJobArn()).add("TuningJobArn", (Object)this.tuningJobArn()).add("ModelArtifacts", (Object)this.modelArtifacts()).add("TrainingJobStatus", (Object)this.trainingJobStatusAsString()).add("SecondaryStatus", (Object)this.secondaryStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("HyperParameters", this.hyperParameters()).add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("RoleArn", (Object)this.roleArn()).add("InputDataConfig", this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ResourceConfig", (Object)this.resourceConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("CreationTime", (Object)this.creationTime()).add("TrainingStartTime", (Object)this.trainingStartTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("SecondaryStatusTransitions", this.secondaryStatusTransitions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "TrainingJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainingJobArn()));
            }
            case "TuningJobArn": {
                return Optional.ofNullable(clazz.cast(this.tuningJobArn()));
            }
            case "ModelArtifacts": {
                return Optional.ofNullable(clazz.cast(this.modelArtifacts()));
            }
            case "TrainingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusAsString()));
            }
            case "SecondaryStatus": {
                return Optional.ofNullable(clazz.cast(this.secondaryStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "HyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "AlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TrainingStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingStartTime()));
            }
            case "TrainingEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "SecondaryStatusTransitions": {
                return Optional.ofNullable(clazz.cast(this.secondaryStatusTransitions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String trainingJobName;
        private String trainingJobArn;
        private String tuningJobArn;
        private ModelArtifacts modelArtifacts;
        private String trainingJobStatus;
        private String secondaryStatus;
        private String failureReason;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private AlgorithmSpecification algorithmSpecification;
        private String roleArn;
        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private OutputDataConfig outputDataConfig;
        private ResourceConfig resourceConfig;
        private VpcConfig vpcConfig;
        private StoppingCondition stoppingCondition;
        private Instant creationTime;
        private Instant trainingStartTime;
        private Instant trainingEndTime;
        private Instant lastModifiedTime;
        private List<SecondaryStatusTransition> secondaryStatusTransitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrainingJobResponse model) {
            super(model);
            this.trainingJobName(model.trainingJobName);
            this.trainingJobArn(model.trainingJobArn);
            this.tuningJobArn(model.tuningJobArn);
            this.modelArtifacts(model.modelArtifacts);
            this.trainingJobStatus(model.trainingJobStatus);
            this.secondaryStatus(model.secondaryStatus);
            this.failureReason(model.failureReason);
            this.hyperParameters(model.hyperParameters);
            this.algorithmSpecification(model.algorithmSpecification);
            this.roleArn(model.roleArn);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.resourceConfig(model.resourceConfig);
            this.vpcConfig(model.vpcConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.creationTime(model.creationTime);
            this.trainingStartTime(model.trainingStartTime);
            this.trainingEndTime(model.trainingEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.secondaryStatusTransitions(model.secondaryStatusTransitions);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final String getTrainingJobArn() {
            return this.trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        public final String getTuningJobArn() {
            return this.tuningJobArn;
        }

        @Override
        public final Builder tuningJobArn(String tuningJobArn) {
            this.tuningJobArn = tuningJobArn;
            return this;
        }

        public final void setTuningJobArn(String tuningJobArn) {
            this.tuningJobArn = tuningJobArn;
        }

        public final ModelArtifacts.Builder getModelArtifacts() {
            return this.modelArtifacts != null ? this.modelArtifacts.toBuilder() : null;
        }

        @Override
        public final Builder modelArtifacts(ModelArtifacts modelArtifacts) {
            this.modelArtifacts = modelArtifacts;
            return this;
        }

        public final void setModelArtifacts(ModelArtifacts.BuilderImpl modelArtifacts) {
            this.modelArtifacts = modelArtifacts != null ? modelArtifacts.build() : null;
        }

        public final String getTrainingJobStatus() {
            return this.trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus.toString());
            return this;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        public final String getSecondaryStatus() {
            return this.secondaryStatus;
        }

        @Override
        public final Builder secondaryStatus(String secondaryStatus) {
            this.secondaryStatus = secondaryStatus;
            return this;
        }

        @Override
        public final Builder secondaryStatus(SecondaryStatus secondaryStatus) {
            this.secondaryStatus(secondaryStatus.toString());
            return this;
        }

        public final void setSecondaryStatus(String secondaryStatus) {
            this.secondaryStatus = secondaryStatus;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Map<String, String> getHyperParameters() {
            return this.hyperParameters;
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Channel.Builder> getInputDataConfig() {
            return this.inputDataConfig != null ? (Collection)this.inputDataConfig.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTrainingStartTime() {
            return this.trainingStartTime;
        }

        @Override
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Collection<SecondaryStatusTransition.Builder> getSecondaryStatusTransitions() {
            return this.secondaryStatusTransitions != null ? (Collection)this.secondaryStatusTransitions.stream().map(SecondaryStatusTransition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions) {
            this.secondaryStatusTransitions = SecondaryStatusTransitionsCopier.copy(secondaryStatusTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryStatusTransitions(SecondaryStatusTransition ... secondaryStatusTransitions) {
            this.secondaryStatusTransitions(Arrays.asList(secondaryStatusTransitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryStatusTransitions(Consumer<SecondaryStatusTransition.Builder> ... secondaryStatusTransitions) {
            this.secondaryStatusTransitions(Stream.of(secondaryStatusTransitions).map(c -> (SecondaryStatusTransition)((SecondaryStatusTransition.Builder)SecondaryStatusTransition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryStatusTransitions(Collection<SecondaryStatusTransition.BuilderImpl> secondaryStatusTransitions) {
            this.secondaryStatusTransitions = SecondaryStatusTransitionsCopier.copyFromBuilder(secondaryStatusTransitions);
        }

        @Override
        public DescribeTrainingJobResponse build() {
            return new DescribeTrainingJobResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, DescribeTrainingJobResponse> {
        public Builder trainingJobName(String var1);

        public Builder trainingJobArn(String var1);

        public Builder tuningJobArn(String var1);

        public Builder modelArtifacts(ModelArtifacts var1);

        default public Builder modelArtifacts(Consumer<ModelArtifacts.Builder> modelArtifacts) {
            return this.modelArtifacts((ModelArtifacts)((ModelArtifacts.Builder)ModelArtifacts.builder().applyMutation(modelArtifacts)).build());
        }

        public Builder trainingJobStatus(String var1);

        public Builder trainingJobStatus(TrainingJobStatus var1);

        public Builder secondaryStatus(String var1);

        public Builder secondaryStatus(SecondaryStatus var1);

        public Builder failureReason(String var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder algorithmSpecification(AlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((AlgorithmSpecification)((AlgorithmSpecification.Builder)AlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputDataConfig(Collection<Channel> var1);

        public Builder inputDataConfig(Channel ... var1);

        public Builder inputDataConfig(Consumer<Channel.Builder> ... var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder trainingStartTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder secondaryStatusTransitions(Collection<SecondaryStatusTransition> var1);

        public Builder secondaryStatusTransitions(SecondaryStatusTransition ... var1);

        public Builder secondaryStatusTransitions(Consumer<SecondaryStatusTransition.Builder> ... var1);
    }
}

