/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus;
import software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHyperParameterTuningJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeHyperParameterTuningJobResponse> {
    private final String hyperParameterTuningJobName;
    private final String hyperParameterTuningJobArn;
    private final HyperParameterTuningJobConfig hyperParameterTuningJobConfig;
    private final HyperParameterTrainingJobDefinition trainingJobDefinition;
    private final String hyperParameterTuningJobStatus;
    private final Instant creationTime;
    private final Instant hyperParameterTuningEndTime;
    private final Instant lastModifiedTime;
    private final TrainingJobStatusCounters trainingJobStatusCounters;
    private final ObjectiveStatusCounters objectiveStatusCounters;
    private final HyperParameterTrainingJobSummary bestTrainingJob;
    private final String failureReason;

    private DescribeHyperParameterTuningJobResponse(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.hyperParameterTuningJobArn = builder.hyperParameterTuningJobArn;
        this.hyperParameterTuningJobConfig = builder.hyperParameterTuningJobConfig;
        this.trainingJobDefinition = builder.trainingJobDefinition;
        this.hyperParameterTuningJobStatus = builder.hyperParameterTuningJobStatus;
        this.creationTime = builder.creationTime;
        this.hyperParameterTuningEndTime = builder.hyperParameterTuningEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatusCounters = builder.trainingJobStatusCounters;
        this.objectiveStatusCounters = builder.objectiveStatusCounters;
        this.bestTrainingJob = builder.bestTrainingJob;
        this.failureReason = builder.failureReason;
    }

    public String hyperParameterTuningJobName() {
        return this.hyperParameterTuningJobName;
    }

    public String hyperParameterTuningJobArn() {
        return this.hyperParameterTuningJobArn;
    }

    public HyperParameterTuningJobConfig hyperParameterTuningJobConfig() {
        return this.hyperParameterTuningJobConfig;
    }

    public HyperParameterTrainingJobDefinition trainingJobDefinition() {
        return this.trainingJobDefinition;
    }

    public HyperParameterTuningJobStatus hyperParameterTuningJobStatus() {
        return HyperParameterTuningJobStatus.fromValue(this.hyperParameterTuningJobStatus);
    }

    public String hyperParameterTuningJobStatusAsString() {
        return this.hyperParameterTuningJobStatus;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant hyperParameterTuningEndTime() {
        return this.hyperParameterTuningEndTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public TrainingJobStatusCounters trainingJobStatusCounters() {
        return this.trainingJobStatusCounters;
    }

    public ObjectiveStatusCounters objectiveStatusCounters() {
        return this.objectiveStatusCounters;
    }

    public HyperParameterTrainingJobSummary bestTrainingJob() {
        return this.bestTrainingJob;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectiveStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.bestTrainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHyperParameterTuningJobResponse)) {
            return false;
        }
        DescribeHyperParameterTuningJobResponse other = (DescribeHyperParameterTuningJobResponse)((Object)obj);
        return Objects.equals(this.hyperParameterTuningJobName(), other.hyperParameterTuningJobName()) && Objects.equals(this.hyperParameterTuningJobArn(), other.hyperParameterTuningJobArn()) && Objects.equals(this.hyperParameterTuningJobConfig(), other.hyperParameterTuningJobConfig()) && Objects.equals(this.trainingJobDefinition(), other.trainingJobDefinition()) && Objects.equals(this.hyperParameterTuningJobStatusAsString(), other.hyperParameterTuningJobStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.hyperParameterTuningEndTime(), other.hyperParameterTuningEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.trainingJobStatusCounters(), other.trainingJobStatusCounters()) && Objects.equals(this.objectiveStatusCounters(), other.objectiveStatusCounters()) && Objects.equals(this.bestTrainingJob(), other.bestTrainingJob()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        return ToString.builder((String)"DescribeHyperParameterTuningJobResponse").add("HyperParameterTuningJobName", (Object)this.hyperParameterTuningJobName()).add("HyperParameterTuningJobArn", (Object)this.hyperParameterTuningJobArn()).add("HyperParameterTuningJobConfig", (Object)this.hyperParameterTuningJobConfig()).add("TrainingJobDefinition", (Object)this.trainingJobDefinition()).add("HyperParameterTuningJobStatus", (Object)this.hyperParameterTuningJobStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("HyperParameterTuningEndTime", (Object)this.hyperParameterTuningEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TrainingJobStatusCounters", (Object)this.trainingJobStatusCounters()).add("ObjectiveStatusCounters", (Object)this.objectiveStatusCounters()).add("BestTrainingJob", (Object)this.bestTrainingJob()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HyperParameterTuningJobName": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobName()));
            }
            case "HyperParameterTuningJobArn": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobArn()));
            }
            case "HyperParameterTuningJobConfig": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobConfig()));
            }
            case "TrainingJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.trainingJobDefinition()));
            }
            case "HyperParameterTuningJobStatus": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "HyperParameterTuningEndTime": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "TrainingJobStatusCounters": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusCounters()));
            }
            case "ObjectiveStatusCounters": {
                return Optional.ofNullable(clazz.cast(this.objectiveStatusCounters()));
            }
            case "BestTrainingJob": {
                return Optional.ofNullable(clazz.cast(this.bestTrainingJob()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String hyperParameterTuningJobName;
        private String hyperParameterTuningJobArn;
        private HyperParameterTuningJobConfig hyperParameterTuningJobConfig;
        private HyperParameterTrainingJobDefinition trainingJobDefinition;
        private String hyperParameterTuningJobStatus;
        private Instant creationTime;
        private Instant hyperParameterTuningEndTime;
        private Instant lastModifiedTime;
        private TrainingJobStatusCounters trainingJobStatusCounters;
        private ObjectiveStatusCounters objectiveStatusCounters;
        private HyperParameterTrainingJobSummary bestTrainingJob;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHyperParameterTuningJobResponse model) {
            super(model);
            this.hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            this.hyperParameterTuningJobArn(model.hyperParameterTuningJobArn);
            this.hyperParameterTuningJobConfig(model.hyperParameterTuningJobConfig);
            this.trainingJobDefinition(model.trainingJobDefinition);
            this.hyperParameterTuningJobStatus(model.hyperParameterTuningJobStatus);
            this.creationTime(model.creationTime);
            this.hyperParameterTuningEndTime(model.hyperParameterTuningEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.trainingJobStatusCounters(model.trainingJobStatusCounters);
            this.objectiveStatusCounters(model.objectiveStatusCounters);
            this.bestTrainingJob(model.bestTrainingJob);
            this.failureReason(model.failureReason);
        }

        public final String getHyperParameterTuningJobName() {
            return this.hyperParameterTuningJobName;
        }

        @Override
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        public final String getHyperParameterTuningJobArn() {
            return this.hyperParameterTuningJobArn;
        }

        @Override
        public final Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
            return this;
        }

        public final void setHyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
        }

        public final HyperParameterTuningJobConfig.Builder getHyperParameterTuningJobConfig() {
            return this.hyperParameterTuningJobConfig != null ? this.hyperParameterTuningJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig;
            return this;
        }

        public final void setHyperParameterTuningJobConfig(HyperParameterTuningJobConfig.BuilderImpl hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.build() : null;
        }

        public final HyperParameterTrainingJobDefinition.Builder getTrainingJobDefinition() {
            return this.trainingJobDefinition != null ? this.trainingJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition;
            return this;
        }

        public final void setTrainingJobDefinition(HyperParameterTrainingJobDefinition.BuilderImpl trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition != null ? trainingJobDefinition.build() : null;
        }

        public final String getHyperParameterTuningJobStatus() {
            return this.hyperParameterTuningJobStatus;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
            return this;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus(hyperParameterTuningJobStatus.toString());
            return this;
        }

        public final void setHyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getHyperParameterTuningEndTime() {
            return this.hyperParameterTuningEndTime;
        }

        @Override
        public final Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
            return this;
        }

        public final void setHyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final TrainingJobStatusCounters.Builder getTrainingJobStatusCounters() {
            return this.trainingJobStatusCounters != null ? this.trainingJobStatusCounters.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters;
            return this;
        }

        public final void setTrainingJobStatusCounters(TrainingJobStatusCounters.BuilderImpl trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters != null ? trainingJobStatusCounters.build() : null;
        }

        public final ObjectiveStatusCounters.Builder getObjectiveStatusCounters() {
            return this.objectiveStatusCounters != null ? this.objectiveStatusCounters.toBuilder() : null;
        }

        @Override
        public final Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters;
            return this;
        }

        public final void setObjectiveStatusCounters(ObjectiveStatusCounters.BuilderImpl objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters != null ? objectiveStatusCounters.build() : null;
        }

        public final HyperParameterTrainingJobSummary.Builder getBestTrainingJob() {
            return this.bestTrainingJob != null ? this.bestTrainingJob.toBuilder() : null;
        }

        @Override
        public final Builder bestTrainingJob(HyperParameterTrainingJobSummary bestTrainingJob) {
            this.bestTrainingJob = bestTrainingJob;
            return this;
        }

        public final void setBestTrainingJob(HyperParameterTrainingJobSummary.BuilderImpl bestTrainingJob) {
            this.bestTrainingJob = bestTrainingJob != null ? bestTrainingJob.build() : null;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public DescribeHyperParameterTuningJobResponse build() {
            return new DescribeHyperParameterTuningJobResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, DescribeHyperParameterTuningJobResponse> {
        public Builder hyperParameterTuningJobName(String var1);

        public Builder hyperParameterTuningJobArn(String var1);

        public Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig var1);

        default public Builder hyperParameterTuningJobConfig(Consumer<HyperParameterTuningJobConfig.Builder> hyperParameterTuningJobConfig) {
            return this.hyperParameterTuningJobConfig((HyperParameterTuningJobConfig)((HyperParameterTuningJobConfig.Builder)HyperParameterTuningJobConfig.builder().applyMutation(hyperParameterTuningJobConfig)).build());
        }

        public Builder trainingJobDefinition(HyperParameterTrainingJobDefinition var1);

        default public Builder trainingJobDefinition(Consumer<HyperParameterTrainingJobDefinition.Builder> trainingJobDefinition) {
            return this.trainingJobDefinition((HyperParameterTrainingJobDefinition)((HyperParameterTrainingJobDefinition.Builder)HyperParameterTrainingJobDefinition.builder().applyMutation(trainingJobDefinition)).build());
        }

        public Builder hyperParameterTuningJobStatus(String var1);

        public Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder hyperParameterTuningEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder trainingJobStatusCounters(TrainingJobStatusCounters var1);

        default public Builder trainingJobStatusCounters(Consumer<TrainingJobStatusCounters.Builder> trainingJobStatusCounters) {
            return this.trainingJobStatusCounters((TrainingJobStatusCounters)((TrainingJobStatusCounters.Builder)TrainingJobStatusCounters.builder().applyMutation(trainingJobStatusCounters)).build());
        }

        public Builder objectiveStatusCounters(ObjectiveStatusCounters var1);

        default public Builder objectiveStatusCounters(Consumer<ObjectiveStatusCounters.Builder> objectiveStatusCounters) {
            return this.objectiveStatusCounters((ObjectiveStatusCounters)((ObjectiveStatusCounters.Builder)ObjectiveStatusCounters.builder().applyMutation(objectiveStatusCounters)).build());
        }

        public Builder bestTrainingJob(HyperParameterTrainingJobSummary var1);

        default public Builder bestTrainingJob(Consumer<HyperParameterTrainingJobSummary.Builder> bestTrainingJob) {
            return this.bestTrainingJob((HyperParameterTrainingJobSummary)((HyperParameterTrainingJobSummary.Builder)HyperParameterTrainingJobSummary.builder().applyMutation(bestTrainingJob)).build());
        }

        public Builder failureReason(String var1);
    }
}

