/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariant;

public class ProductionVariantUnmarshaller
implements Unmarshaller<ProductionVariant, JsonUnmarshallerContext> {
    private static final ProductionVariantUnmarshaller INSTANCE = new ProductionVariantUnmarshaller();

    public ProductionVariant unmarshall(JsonUnmarshallerContext context) throws Exception {
        ProductionVariant.Builder productionVariantBuilder = ProductionVariant.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("VariantName", targetDepth)) {
                    context.nextToken();
                    productionVariantBuilder.variantName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ModelName", targetDepth)) {
                    context.nextToken();
                    productionVariantBuilder.modelName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InitialInstanceCount", targetDepth)) {
                    context.nextToken();
                    productionVariantBuilder.initialInstanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    productionVariantBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InitialVariantWeight", targetDepth)) {
                    context.nextToken();
                    productionVariantBuilder.initialVariantWeight((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ProductionVariant)productionVariantBuilder.build();
    }

    public static ProductionVariantUnmarshaller getInstance() {
        return INSTANCE;
    }
}

