/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.ModelArtifacts;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModelArtifactsMarshaller {
    private static final MarshallingInfo<String> S3MODELARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ModelArtifacts").isBinary(false).build();
    private static final ModelArtifactsMarshaller INSTANCE = new ModelArtifactsMarshaller();

    private ModelArtifactsMarshaller() {
    }

    public static ModelArtifactsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModelArtifacts modelArtifacts, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)modelArtifacts, (String)"modelArtifacts");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modelArtifacts.s3ModelArtifacts(), S3MODELARTIFACTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

