/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateEndpointConfigRequestModelMarshaller {
    private static final MarshallingInfo<String> ENDPOINTCONFIGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointConfigName").isBinary(false).build();
    private static final MarshallingInfo<List> PRODUCTIONVARIANTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductionVariants").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final CreateEndpointConfigRequestModelMarshaller INSTANCE = new CreateEndpointConfigRequestModelMarshaller();

    private CreateEndpointConfigRequestModelMarshaller() {
    }

    public static CreateEndpointConfigRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateEndpointConfigRequest createEndpointConfigRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createEndpointConfigRequest), (String)"createEndpointConfigRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createEndpointConfigRequest.endpointConfigName(), ENDPOINTCONFIGNAME_BINDING);
            protocolMarshaller.marshall(createEndpointConfigRequest.productionVariants(), PRODUCTIONVARIANTS_BINDING);
            protocolMarshaller.marshall(createEndpointConfigRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

