/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;

public class ListModelsPublisher
implements SdkPublisher<ListModelsResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelsPublisher(SageMakerAsyncClient client, ListModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelsPublisher(SageMakerAsyncClient client, ListModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListModelsPublisher resume(ListModelsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListModelsPublisher(this.client, (ListModelsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListModelsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListModelsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListModelsResponseFetcher
    implements AsyncPageFetcher<ListModelsResponse> {
        private ListModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListModelsResponse> nextPage(ListModelsResponse previousPage) {
            if (previousPage == null) {
                return ListModelsPublisher.this.client.listModels(ListModelsPublisher.this.firstRequest);
            }
            return ListModelsPublisher.this.client.listModels((ListModelsRequest)((Object)ListModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

