/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.InstanceType;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus;
import software.amazon.awssdk.services.sagemaker.transform.NotebookInstanceSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotebookInstanceSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, NotebookInstanceSummary> {
    private final String notebookInstanceName;
    private final String notebookInstanceArn;
    private final String notebookInstanceStatus;
    private final String url;
    private final String instanceType;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private NotebookInstanceSummary(BuilderImpl builder) {
        this.notebookInstanceName = builder.notebookInstanceName;
        this.notebookInstanceArn = builder.notebookInstanceArn;
        this.notebookInstanceStatus = builder.notebookInstanceStatus;
        this.url = builder.url;
        this.instanceType = builder.instanceType;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public String notebookInstanceArn() {
        return this.notebookInstanceArn;
    }

    public NotebookInstanceStatus notebookInstanceStatus() {
        return NotebookInstanceStatus.fromValue(this.notebookInstanceStatus);
    }

    public String notebookInstanceStatusAsString() {
        return this.notebookInstanceStatus;
    }

    public String url() {
        return this.url;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookInstanceSummary)) {
            return false;
        }
        NotebookInstanceSummary other = (NotebookInstanceSummary)obj;
        return Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.notebookInstanceArn(), other.notebookInstanceArn()) && Objects.equals(this.notebookInstanceStatusAsString(), other.notebookInstanceStatusAsString()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public String toString() {
        return ToString.builder((String)"NotebookInstanceSummary").add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("NotebookInstanceArn", (Object)this.notebookInstanceArn()).add("NotebookInstanceStatus", (Object)this.notebookInstanceStatusAsString()).add("Url", (Object)this.url()).add("InstanceType", (Object)this.instanceTypeAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceName()));
            }
            case "NotebookInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceArn()));
            }
            case "NotebookInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceStatusAsString()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotebookInstanceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String notebookInstanceName;
        private String notebookInstanceArn;
        private String notebookInstanceStatus;
        private String url;
        private String instanceType;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookInstanceSummary model) {
            this.notebookInstanceName(model.notebookInstanceName);
            this.notebookInstanceArn(model.notebookInstanceArn);
            this.notebookInstanceStatus(model.notebookInstanceStatus);
            this.url(model.url);
            this.instanceType(model.instanceType);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        public final String getNotebookInstanceArn() {
            return this.notebookInstanceArn;
        }

        @Override
        public final Builder notebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
            return this;
        }

        public final void setNotebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
        }

        public final String getNotebookInstanceStatus() {
            return this.notebookInstanceStatus;
        }

        @Override
        public final Builder notebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
            return this;
        }

        @Override
        public final Builder notebookInstanceStatus(NotebookInstanceStatus notebookInstanceStatus) {
            this.notebookInstanceStatus(notebookInstanceStatus.toString());
            return this;
        }

        public final void setNotebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public NotebookInstanceSummary build() {
            return new NotebookInstanceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NotebookInstanceSummary> {
        public Builder notebookInstanceName(String var1);

        public Builder notebookInstanceArn(String var1);

        public Builder notebookInstanceStatus(String var1);

        public Builder notebookInstanceStatus(NotebookInstanceStatus var1);

        public Builder url(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

