/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceConfigMarshaller {
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> VOLUMESIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSizeInGB").isBinary(false).build();
    private static final ResourceConfigMarshaller INSTANCE = new ResourceConfigMarshaller();

    private ResourceConfigMarshaller() {
    }

    public static ResourceConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceConfig resourceConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceConfig, (String)"resourceConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceConfig.instanceTypeAsString(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceConfig.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)resourceConfig.volumeSizeInGB(), VOLUMESIZEINGB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

