/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotebookInstanceSummaryMarshaller {
    private static final MarshallingInfo<String> NOTEBOOKINSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotebookInstanceName").isBinary(false).build();
    private static final MarshallingInfo<String> NOTEBOOKINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotebookInstanceArn").isBinary(false).build();
    private static final MarshallingInfo<String> NOTEBOOKINSTANCESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotebookInstanceStatus").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").isBinary(false).build();
    private static final NotebookInstanceSummaryMarshaller INSTANCE = new NotebookInstanceSummaryMarshaller();

    private NotebookInstanceSummaryMarshaller() {
    }

    public static NotebookInstanceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotebookInstanceSummary notebookInstanceSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)notebookInstanceSummary, (String)"notebookInstanceSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notebookInstanceSummary.notebookInstanceName(), NOTEBOOKINSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.notebookInstanceArn(), NOTEBOOKINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.notebookInstanceStatusAsString(), NOTEBOOKINSTANCESTATUS_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.url(), URL_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.instanceTypeAsString(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)notebookInstanceSummary.lastModifiedTime(), LASTMODIFIEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

