/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.EndpointSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointSummaryMarshaller {
    private static final MarshallingInfo<String> ENDPOINTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointName").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointStatus").isBinary(false).build();
    private static final EndpointSummaryMarshaller INSTANCE = new EndpointSummaryMarshaller();

    private EndpointSummaryMarshaller() {
    }

    public static EndpointSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointSummary endpointSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpointSummary, (String)"endpointSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)endpointSummary.endpointName(), ENDPOINTNAME_BINDING);
            protocolMarshaller.marshall((Object)endpointSummary.endpointArn(), ENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)endpointSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)endpointSummary.lastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)endpointSummary.endpointStatusAsString(), ENDPOINTSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

