/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification;

public class AlgorithmSpecificationUnmarshaller
implements Unmarshaller<AlgorithmSpecification, JsonUnmarshallerContext> {
    private static final AlgorithmSpecificationUnmarshaller INSTANCE = new AlgorithmSpecificationUnmarshaller();

    public AlgorithmSpecification unmarshall(JsonUnmarshallerContext context) throws Exception {
        AlgorithmSpecification.Builder algorithmSpecificationBuilder = AlgorithmSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TrainingImage", targetDepth)) {
                    context.nextToken();
                    algorithmSpecificationBuilder.trainingImage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TrainingInputMode", targetDepth)) {
                    context.nextToken();
                    algorithmSpecificationBuilder.trainingInputMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AlgorithmSpecification)algorithmSpecificationBuilder.build();
    }

    public static AlgorithmSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

