/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.services.sagemaker.transform.TrainingJobSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrainingJobSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, TrainingJobSummary> {
    private final String trainingJobName;
    private final String trainingJobArn;
    private final Instant creationTime;
    private final Instant trainingEndTime;
    private final Instant lastModifiedTime;
    private final String trainingJobStatus;

    private TrainingJobSummary(BuilderImpl builder) {
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.creationTime = builder.creationTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatus = builder.trainingJobStatus;
    }

    public String trainingJobName() {
        return this.trainingJobName;
    }

    public String trainingJobArn() {
        return this.trainingJobArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(this.trainingJobStatus);
    }

    public String trainingJobStatusAsString() {
        return this.trainingJobStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobSummary)) {
            return false;
        }
        TrainingJobSummary other = (TrainingJobSummary)obj;
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.trainingJobArn(), other.trainingJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.trainingJobStatusAsString(), other.trainingJobStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"TrainingJobSummary").add("TrainingJobName", (Object)this.trainingJobName()).add("TrainingJobArn", (Object)this.trainingJobArn()).add("CreationTime", (Object)this.creationTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TrainingJobStatus", (Object)this.trainingJobStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.of(clazz.cast(this.trainingJobName()));
            }
            case "TrainingJobArn": {
                return Optional.of(clazz.cast(this.trainingJobArn()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "TrainingEndTime": {
                return Optional.of(clazz.cast(this.trainingEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.of(clazz.cast(this.lastModifiedTime()));
            }
            case "TrainingJobStatus": {
                return Optional.of(clazz.cast(this.trainingJobStatusAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrainingJobSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingJobName;
        private String trainingJobArn;
        private Instant creationTime;
        private Instant trainingEndTime;
        private Instant lastModifiedTime;
        private String trainingJobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJobSummary model) {
            this.trainingJobName(model.trainingJobName);
            this.trainingJobArn(model.trainingJobArn);
            this.creationTime(model.creationTime);
            this.trainingEndTime(model.trainingEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.trainingJobStatus(model.trainingJobStatus);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final String getTrainingJobArn() {
            return this.trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getTrainingJobStatus() {
            return this.trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus.toString());
            return this;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        public TrainingJobSummary build() {
            return new TrainingJobSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrainingJobSummary> {
        public Builder trainingJobName(String var1);

        public Builder trainingJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder trainingJobStatus(String var1);

        public Builder trainingJobStatus(TrainingJobStatus var1);
    }
}

