/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes of a vector in the approximate nearest neighbor search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryOutputVector implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryOutputVector.Builder, QueryOutputVector> {
    private static final SdkField<Float> DISTANCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("distance")
            .getter(getter(QueryOutputVector::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distance").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(QueryOutputVector::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<Document> METADATA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("metadata").getter(getter(QueryOutputVector::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTANCE_FIELD, KEY_FIELD,
            METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float distance;

    private final String key;

    private final Document metadata;

    private QueryOutputVector(BuilderImpl builder) {
        this.distance = builder.distance;
        this.key = builder.key;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The measure of similarity between the vector in the response and the query vector.
     * </p>
     * 
     * @return The measure of similarity between the vector in the response and the query vector.
     */
    public final Float distance() {
        return distance;
    }

    /**
     * <p>
     * The key of the vector in the approximate nearest neighbor search.
     * </p>
     * 
     * @return The key of the vector in the approximate nearest neighbor search.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The metadata associated with the vector, if requested.
     * </p>
     * 
     * @return The metadata associated with the vector, if requested.
     */
    public final Document metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryOutputVector)) {
            return false;
        }
        QueryOutputVector other = (QueryOutputVector) obj;
        return Objects.equals(distance(), other.distance()) && Objects.equals(key(), other.key())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryOutputVector").add("Distance", distance()).add("Key", key()).add("Metadata", metadata())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("distance", DISTANCE_FIELD);
        map.put("key", KEY_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryOutputVector, T> g) {
        return obj -> g.apply((QueryOutputVector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryOutputVector> {
        /**
         * <p>
         * The measure of similarity between the vector in the response and the query vector.
         * </p>
         * 
         * @param distance
         *        The measure of similarity between the vector in the response and the query vector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Float distance);

        /**
         * <p>
         * The key of the vector in the approximate nearest neighbor search.
         * </p>
         * 
         * @param key
         *        The key of the vector in the approximate nearest neighbor search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The metadata associated with the vector, if requested.
         * </p>
         * 
         * @param metadata
         *        The metadata associated with the vector, if requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Document metadata);
    }

    static final class BuilderImpl implements Builder {
        private Float distance;

        private String key;

        private Document metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryOutputVector model) {
            distance(model.distance);
            key(model.key);
            metadata(model.metadata);
        }

        public final Float getDistance() {
            return distance;
        }

        public final void setDistance(Float distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Document getMetadata() {
            return metadata;
        }

        public final void setMetadata(Document metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(Document metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public QueryOutputVector build() {
            return new QueryOutputVector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
