/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.s3vectors.S3VectorsClient;
import software.amazon.awssdk.services.s3vectors.S3VectorsServiceClientConfiguration;
import software.amazon.awssdk.services.s3vectors.internal.S3VectorsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.s3vectors.model.AccessDeniedException;
import software.amazon.awssdk.services.s3vectors.model.ConflictException;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.GetIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.GetIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.InternalServerException;
import software.amazon.awssdk.services.s3vectors.model.KmsDisabledException;
import software.amazon.awssdk.services.s3vectors.model.KmsInvalidKeyUsageException;
import software.amazon.awssdk.services.s3vectors.model.KmsInvalidStateException;
import software.amazon.awssdk.services.s3vectors.model.KmsNotFoundException;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.NotFoundException;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.RequestTimeoutException;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsException;
import software.amazon.awssdk.services.s3vectors.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.s3vectors.model.ServiceUnavailableException;
import software.amazon.awssdk.services.s3vectors.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3vectors.model.ValidationException;
import software.amazon.awssdk.services.s3vectors.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.CreateVectorBucketRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.DeleteIndexRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.DeleteVectorBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.DeleteVectorBucketRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.DeleteVectorsRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.GetIndexRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.GetVectorBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.GetVectorBucketRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.GetVectorsRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.ListIndexesRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.ListVectorBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.ListVectorsRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.PutVectorBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.PutVectorsRequestMarshaller;
import software.amazon.awssdk.services.s3vectors.transform.QueryVectorsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultS3VectorsClient
implements S3VectorsClient {
    private static final Logger log = Logger.loggerFor(DefaultS3VectorsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3VectorsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"S3Vectors#2.38.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, ConflictException, NotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, createIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIndex");
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIndex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$createIndex$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVectorBucketResponse createVectorBucket(CreateVectorBucketRequest createVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVectorBucketResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVectorBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, createVectorBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVectorBucket");
            CreateVectorBucketResponse createVectorBucketResponse = (CreateVectorBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVectorBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVectorBucketRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVectorBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVectorBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$createVectorBucket$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, deleteIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIndex");
            DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIndex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$deleteIndex$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVectorBucketResponse deleteVectorBucket(DeleteVectorBucketRequest deleteVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, ConflictException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVectorBucketResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVectorBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, deleteVectorBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVectorBucket");
            DeleteVectorBucketResponse deleteVectorBucketResponse = (DeleteVectorBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVectorBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVectorBucketRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVectorBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVectorBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$deleteVectorBucket$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVectorBucketPolicyResponse deleteVectorBucketPolicy(DeleteVectorBucketPolicyRequest deleteVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVectorBucketPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVectorBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, deleteVectorBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVectorBucketPolicy");
            DeleteVectorBucketPolicyResponse deleteVectorBucketPolicyResponse = (DeleteVectorBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVectorBucketPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVectorBucketPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVectorBucketPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVectorBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$deleteVectorBucketPolicy$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVectorsResponse deleteVectors(DeleteVectorsRequest deleteVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, deleteVectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVectors");
            DeleteVectorsResponse deleteVectorsResponse = (DeleteVectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$deleteVectors$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, getIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIndex");
            GetIndexResponse getIndexResponse = (GetIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIndex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$getIndex$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVectorBucketResponse getVectorBucket(GetVectorBucketRequest getVectorBucketRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVectorBucketResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getVectorBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, getVectorBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVectorBucket");
            GetVectorBucketResponse getVectorBucketResponse = (GetVectorBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVectorBucket").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getVectorBucketRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetVectorBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getVectorBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$getVectorBucket$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVectorBucketPolicyResponse getVectorBucketPolicy(GetVectorBucketPolicyRequest getVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVectorBucketPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getVectorBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, getVectorBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVectorBucketPolicy");
            GetVectorBucketPolicyResponse getVectorBucketPolicyResponse = (GetVectorBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVectorBucketPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getVectorBucketPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetVectorBucketPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getVectorBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$getVectorBucketPolicy$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVectorsResponse getVectors(GetVectorsRequest getVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getVectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, getVectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVectors");
            GetVectorsResponse getVectorsResponse = (GetVectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getVectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetVectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getVectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$getVectors$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIndexesResponse listIndexes(ListIndexesRequest listIndexesRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIndexesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIndexesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, listIndexesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIndexes");
            ListIndexesResponse listIndexesResponse = (ListIndexesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIndexes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listIndexesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIndexesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIndexesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$listIndexes$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVectorBucketsResponse listVectorBuckets(ListVectorBucketsRequest listVectorBucketsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVectorBucketsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVectorBucketsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, listVectorBucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVectorBuckets");
            ListVectorBucketsResponse listVectorBucketsResponse = (ListVectorBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVectorBuckets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVectorBucketsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVectorBucketsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVectorBucketsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$listVectorBuckets$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVectorsResponse listVectors(ListVectorsRequest listVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, listVectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVectors");
            ListVectorsResponse listVectorsResponse = (ListVectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$listVectors$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutVectorBucketPolicyResponse putVectorBucketPolicy(PutVectorBucketPolicyRequest putVectorBucketPolicyRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVectorBucketPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putVectorBucketPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, putVectorBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVectorBucketPolicy");
            PutVectorBucketPolicyResponse putVectorBucketPolicyResponse = (PutVectorBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVectorBucketPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putVectorBucketPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutVectorBucketPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putVectorBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$putVectorBucketPolicy$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutVectorsResponse putVectors(PutVectorsRequest putVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException, ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutVectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putVectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, putVectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutVectors");
            PutVectorsResponse putVectorsResponse = (PutVectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutVectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putVectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutVectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putVectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$putVectors$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryVectorsResponse queryVectors(QueryVectorsRequest queryVectorsRequest) throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryVectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "KmsInvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).build());
                }
                case "RequestTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(Integer.valueOf(408)).exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                }
                case "KmsInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "KmsNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "KmsDisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)queryVectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultS3VectorsClient.resolveMetricPublishers(clientConfiguration, queryVectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3Vectors");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"QueryVectors");
            QueryVectorsResponse queryVectorsResponse = (QueryVectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("QueryVectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)queryVectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new QueryVectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return queryVectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3VectorsClient.lambda$queryVectors$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "s3vectors";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        S3VectorsServiceClientConfigurationBuilder serviceConfigBuilder = new S3VectorsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(S3VectorsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final S3VectorsServiceClientConfiguration serviceClientConfiguration() {
        return new S3VectorsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$queryVectors$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVectors$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putVectorBucketPolicy$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVectors$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVectorBuckets$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIndexes$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVectors$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVectorBucketPolicy$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVectorBucket$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIndex$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVectors$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVectorBucketPolicy$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVectorBucket$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIndex$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVectorBucket$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIndex$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

