/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3vectors.model.VectorData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInputVector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PutInputVector> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(PutInputVector.getter(PutInputVector::key)).setter(PutInputVector.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<VectorData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("data").getter(PutInputVector.getter(PutInputVector::data)).setter(PutInputVector.setter(Builder::data)).constructor(VectorData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<Document> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("metadata").getter(PutInputVector.getter(PutInputVector::metadata)).setter(PutInputVector.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, DATA_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutInputVector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final VectorData data;
    private final Document metadata;

    private PutInputVector(BuilderImpl builder) {
        this.key = builder.key;
        this.data = builder.data;
        this.metadata = builder.metadata;
    }

    public final String key() {
        return this.key;
    }

    public final VectorData data() {
        return this.data;
    }

    public final Document metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInputVector)) {
            return false;
        }
        PutInputVector other = (PutInputVector)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"PutInputVector").add("Key", (Object)this.key()).add("Data", (Object)this.data()).add("Metadata", (Object)this.metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", KEY_FIELD);
        map.put("data", DATA_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutInputVector, T> g) {
        return obj -> g.apply((PutInputVector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private VectorData data;
        private Document metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInputVector model) {
            this.key(model.key);
            this.data(model.data);
            this.metadata(model.metadata);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final VectorData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(VectorData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(VectorData data) {
            this.data = data;
            return this;
        }

        public final Document getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(Document metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(Document metadata) {
            this.metadata = metadata;
            return this;
        }

        public PutInputVector build() {
            return new PutInputVector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PutInputVector> {
        public Builder key(String var1);

        public Builder data(VectorData var1);

        default public Builder data(Consumer<VectorData.Builder> data) {
            return this.data((VectorData)((VectorData.Builder)VectorData.builder().applyMutation(data)).build());
        }

        public Builder metadata(Document var1);
    }
}

