/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVectorBucketResponse extends S3VectorsResponse implements
        ToCopyableBuilder<GetVectorBucketResponse.Builder, GetVectorBucketResponse> {
    private static final SdkField<VectorBucket> VECTOR_BUCKET_FIELD = SdkField.<VectorBucket> builder(MarshallingType.SDK_POJO)
            .memberName("vectorBucket").getter(getter(GetVectorBucketResponse::vectorBucket))
            .setter(setter(Builder::vectorBucket)).constructor(VectorBucket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VectorBucket vectorBucket;

    private GetVectorBucketResponse(BuilderImpl builder) {
        super(builder);
        this.vectorBucket = builder.vectorBucket;
    }

    /**
     * <p>
     * The attributes of the vector bucket.
     * </p>
     * 
     * @return The attributes of the vector bucket.
     */
    public final VectorBucket vectorBucket() {
        return vectorBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVectorBucketResponse)) {
            return false;
        }
        GetVectorBucketResponse other = (GetVectorBucketResponse) obj;
        return Objects.equals(vectorBucket(), other.vectorBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVectorBucketResponse").add("VectorBucket", vectorBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucket":
            return Optional.ofNullable(clazz.cast(vectorBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucket", VECTOR_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVectorBucketResponse, T> g) {
        return obj -> g.apply((GetVectorBucketResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVectorBucketResponse> {
        /**
         * <p>
         * The attributes of the vector bucket.
         * </p>
         * 
         * @param vectorBucket
         *        The attributes of the vector bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucket(VectorBucket vectorBucket);

        /**
         * <p>
         * The attributes of the vector bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorBucket.Builder} avoiding the need
         * to create one manually via {@link VectorBucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorBucket.Builder#build()} is called immediately and its
         * result is passed to {@link #vectorBucket(VectorBucket)}.
         * 
         * @param vectorBucket
         *        a consumer that will call methods on {@link VectorBucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorBucket(VectorBucket)
         */
        default Builder vectorBucket(Consumer<VectorBucket.Builder> vectorBucket) {
            return vectorBucket(VectorBucket.builder().applyMutation(vectorBucket).build());
        }
    }

    static final class BuilderImpl extends S3VectorsResponse.BuilderImpl implements Builder {
        private VectorBucket vectorBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVectorBucketResponse model) {
            super(model);
            vectorBucket(model.vectorBucket);
        }

        public final VectorBucket.Builder getVectorBucket() {
            return vectorBucket != null ? vectorBucket.toBuilder() : null;
        }

        public final void setVectorBucket(VectorBucket.BuilderImpl vectorBucket) {
            this.vectorBucket = vectorBucket != null ? vectorBucket.build() : null;
        }

        @Override
        public final Builder vectorBucket(VectorBucket vectorBucket) {
            this.vectorBucket = vectorBucket;
            return this;
        }

        @Override
        public GetVectorBucketResponse build() {
            return new GetVectorBucketResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
