/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVectorBucketPolicyRequest extends S3VectorsRequest implements
        ToCopyableBuilder<PutVectorBucketPolicyRequest.Builder, PutVectorBucketPolicyRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketName").getter(getter(PutVectorBucketPolicyRequest::vectorBucketName))
            .setter(setter(Builder::vectorBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()).build();

    private static final SdkField<String> VECTOR_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketArn").getter(getter(PutVectorBucketPolicyRequest::vectorBucketArn))
            .setter(setter(Builder::vectorBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketArn").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(PutVectorBucketPolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD,
            VECTOR_BUCKET_ARN_FIELD, POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vectorBucketName;

    private final String vectorBucketArn;

    private final String policy;

    private PutVectorBucketPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.vectorBucketArn = builder.vectorBucketArn;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The name of the vector bucket.
     * </p>
     * 
     * @return The name of the vector bucket.
     */
    public final String vectorBucketName() {
        return vectorBucketName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vector bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vector bucket.
     */
    public final String vectorBucketArn() {
        return vectorBucketArn;
    }

    /**
     * <p>
     * The <code>JSON</code> that defines the policy. For more information about bucket policies for S3 Vectors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-bucket-policy.html">Managing vector bucket
     * policies</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * 
     * @return The <code>JSON</code> that defines the policy. For more information about bucket policies for S3 Vectors,
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-bucket-policy.html">Managing
     *         vector bucket policies</a> in the <i>Amazon S3 User Guide</i>.
     */
    public final String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVectorBucketPolicyRequest)) {
            return false;
        }
        PutVectorBucketPolicyRequest other = (PutVectorBucketPolicyRequest) obj;
        return Objects.equals(vectorBucketName(), other.vectorBucketName())
                && Objects.equals(vectorBucketArn(), other.vectorBucketArn()) && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutVectorBucketPolicyRequest").add("VectorBucketName", vectorBucketName())
                .add("VectorBucketArn", vectorBucketArn()).add("Policy", policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucketName":
            return Optional.ofNullable(clazz.cast(vectorBucketName()));
        case "vectorBucketArn":
            return Optional.ofNullable(clazz.cast(vectorBucketArn()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("vectorBucketArn", VECTOR_BUCKET_ARN_FIELD);
        map.put("policy", POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutVectorBucketPolicyRequest, T> g) {
        return obj -> g.apply((PutVectorBucketPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutVectorBucketPolicyRequest> {
        /**
         * <p>
         * The name of the vector bucket.
         * </p>
         * 
         * @param vectorBucketName
         *        The name of the vector bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketName(String vectorBucketName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vector bucket.
         * </p>
         * 
         * @param vectorBucketArn
         *        The Amazon Resource Name (ARN) of the vector bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketArn(String vectorBucketArn);

        /**
         * <p>
         * The <code>JSON</code> that defines the policy. For more information about bucket policies for S3 Vectors, see
         * <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-bucket-policy.html">Managing vector
         * bucket policies</a> in the <i>Amazon S3 User Guide</i>.
         * </p>
         * 
         * @param policy
         *        The <code>JSON</code> that defines the policy. For more information about bucket policies for S3
         *        Vectors, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-bucket-policy.html">Managing
         *        vector bucket policies</a> in the <i>Amazon S3 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3VectorsRequest.BuilderImpl implements Builder {
        private String vectorBucketName;

        private String vectorBucketArn;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVectorBucketPolicyRequest model) {
            super(model);
            vectorBucketName(model.vectorBucketName);
            vectorBucketArn(model.vectorBucketArn);
            policy(model.policy);
        }

        public final String getVectorBucketName() {
            return vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getVectorBucketArn() {
            return vectorBucketArn;
        }

        public final void setVectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
        }

        @Override
        public final Builder vectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVectorBucketPolicyRequest build() {
            return new PutVectorBucketPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
