/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SseType {
    AES256("AES256"),
    AWS_KMS("aws:kms"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SseType> VALUE_MAP;
    private final String value;

    private SseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SseType> knownValues() {
        EnumSet<SseType> knownValues = EnumSet.allOf(SseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SseType.class, SseType::toString);
    }
}

