/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVectorsRequest
extends S3VectorsRequest
implements ToCopyableBuilder<Builder, ListVectorsRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketName").getter(ListVectorsRequest.getter(ListVectorsRequest::vectorBucketName)).setter(ListVectorsRequest.setter(Builder::vectorBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(ListVectorsRequest.getter(ListVectorsRequest::indexName)).setter(ListVectorsRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexArn").getter(ListVectorsRequest.getter(ListVectorsRequest::indexArn)).setter(ListVectorsRequest.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListVectorsRequest.getter(ListVectorsRequest::maxResults)).setter(ListVectorsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVectorsRequest.getter(ListVectorsRequest::nextToken)).setter(ListVectorsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> SEGMENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("segmentCount").getter(ListVectorsRequest.getter(ListVectorsRequest::segmentCount)).setter(ListVectorsRequest.setter(Builder::segmentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentCount").build()}).build();
    private static final SdkField<Integer> SEGMENT_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("segmentIndex").getter(ListVectorsRequest.getter(ListVectorsRequest::segmentIndex)).setter(ListVectorsRequest.setter(Builder::segmentIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentIndex").build()}).build();
    private static final SdkField<Boolean> RETURN_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("returnData").getter(ListVectorsRequest.getter(ListVectorsRequest::returnData)).setter(ListVectorsRequest.setter(Builder::returnData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnData").build()}).build();
    private static final SdkField<Boolean> RETURN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("returnMetadata").getter(ListVectorsRequest.getter(ListVectorsRequest::returnMetadata)).setter(ListVectorsRequest.setter(Builder::returnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD, INDEX_NAME_FIELD, INDEX_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEGMENT_COUNT_FIELD, SEGMENT_INDEX_FIELD, RETURN_DATA_FIELD, RETURN_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVectorsRequest.memberNameToFieldInitializer();
    private final String vectorBucketName;
    private final String indexName;
    private final String indexArn;
    private final Integer maxResults;
    private final String nextToken;
    private final Integer segmentCount;
    private final Integer segmentIndex;
    private final Boolean returnData;
    private final Boolean returnMetadata;

    private ListVectorsRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.segmentCount = builder.segmentCount;
        this.segmentIndex = builder.segmentIndex;
        this.returnData = builder.returnData;
        this.returnMetadata = builder.returnMetadata;
    }

    public final String vectorBucketName() {
        return this.vectorBucketName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer segmentCount() {
        return this.segmentCount;
    }

    public final Integer segmentIndex() {
        return this.segmentIndex;
    }

    public final Boolean returnData() {
        return this.returnData;
    }

    public final Boolean returnMetadata() {
        return this.returnMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnData());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVectorsRequest)) {
            return false;
        }
        ListVectorsRequest other = (ListVectorsRequest)((Object)obj);
        return Objects.equals(this.vectorBucketName(), other.vectorBucketName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.segmentCount(), other.segmentCount()) && Objects.equals(this.segmentIndex(), other.segmentIndex()) && Objects.equals(this.returnData(), other.returnData()) && Objects.equals(this.returnMetadata(), other.returnMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"ListVectorsRequest").add("VectorBucketName", (Object)this.vectorBucketName()).add("IndexName", (Object)this.indexName()).add("IndexArn", (Object)this.indexArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SegmentCount", (Object)this.segmentCount()).add("SegmentIndex", (Object)this.segmentIndex()).add("ReturnData", (Object)this.returnData()).add("ReturnMetadata", (Object)this.returnMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vectorBucketName": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketName()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "indexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "segmentCount": {
                return Optional.ofNullable(clazz.cast(this.segmentCount()));
            }
            case "segmentIndex": {
                return Optional.ofNullable(clazz.cast(this.segmentIndex()));
            }
            case "returnData": {
                return Optional.ofNullable(clazz.cast(this.returnData()));
            }
            case "returnMetadata": {
                return Optional.ofNullable(clazz.cast(this.returnMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("segmentCount", SEGMENT_COUNT_FIELD);
        map.put("segmentIndex", SEGMENT_INDEX_FIELD);
        map.put("returnData", RETURN_DATA_FIELD);
        map.put("returnMetadata", RETURN_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVectorsRequest, T> g) {
        return obj -> g.apply((ListVectorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3VectorsRequest.BuilderImpl
    implements Builder {
        private String vectorBucketName;
        private String indexName;
        private String indexArn;
        private Integer maxResults;
        private String nextToken;
        private Integer segmentCount;
        private Integer segmentIndex;
        private Boolean returnData;
        private Boolean returnMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVectorsRequest model) {
            super(model);
            this.vectorBucketName(model.vectorBucketName);
            this.indexName(model.indexName);
            this.indexArn(model.indexArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.segmentCount(model.segmentCount);
            this.segmentIndex(model.segmentIndex);
            this.returnData(model.returnData);
            this.returnMetadata(model.returnMetadata);
        }

        public final String getVectorBucketName() {
            return this.vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getSegmentCount() {
            return this.segmentCount;
        }

        public final void setSegmentCount(Integer segmentCount) {
            this.segmentCount = segmentCount;
        }

        @Override
        public final Builder segmentCount(Integer segmentCount) {
            this.segmentCount = segmentCount;
            return this;
        }

        public final Integer getSegmentIndex() {
            return this.segmentIndex;
        }

        public final void setSegmentIndex(Integer segmentIndex) {
            this.segmentIndex = segmentIndex;
        }

        @Override
        public final Builder segmentIndex(Integer segmentIndex) {
            this.segmentIndex = segmentIndex;
            return this;
        }

        public final Boolean getReturnData() {
            return this.returnData;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        public final Boolean getReturnMetadata() {
            return this.returnMetadata;
        }

        public final void setReturnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
        }

        @Override
        public final Builder returnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVectorsRequest build() {
            return new ListVectorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3VectorsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVectorsRequest> {
        public Builder vectorBucketName(String var1);

        public Builder indexName(String var1);

        public Builder indexArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder segmentCount(Integer var1);

        public Builder segmentIndex(Integer var1);

        public Builder returnData(Boolean var1);

        public Builder returnMetadata(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

