/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3vectors.model.QueryOutputVector;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsOutputListCopier;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryVectorsResponse
extends S3VectorsResponse
implements ToCopyableBuilder<Builder, QueryVectorsResponse> {
    private static final SdkField<List<QueryOutputVector>> VECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vectors").getter(QueryVectorsResponse.getter(QueryVectorsResponse::vectors)).setter(QueryVectorsResponse.setter(Builder::vectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryOutputVector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryVectorsResponse.memberNameToFieldInitializer();
    private final List<QueryOutputVector> vectors;

    private QueryVectorsResponse(BuilderImpl builder) {
        super(builder);
        this.vectors = builder.vectors;
    }

    public final boolean hasVectors() {
        return this.vectors != null && !(this.vectors instanceof SdkAutoConstructList);
    }

    public final List<QueryOutputVector> vectors() {
        return this.vectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVectors() ? this.vectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryVectorsResponse)) {
            return false;
        }
        QueryVectorsResponse other = (QueryVectorsResponse)((Object)obj);
        return this.hasVectors() == other.hasVectors() && Objects.equals(this.vectors(), other.vectors());
    }

    public final String toString() {
        return ToString.builder((String)"QueryVectorsResponse").add("Vectors", this.hasVectors() ? this.vectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vectors": {
                return Optional.ofNullable(clazz.cast(this.vectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<QueryOutputVector>>> map = new HashMap<String, SdkField<List<QueryOutputVector>>>();
        map.put("vectors", VECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryVectorsResponse, T> g) {
        return obj -> g.apply((QueryVectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3VectorsResponse.BuilderImpl
    implements Builder {
        private List<QueryOutputVector> vectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryVectorsResponse model) {
            super(model);
            this.vectors(model.vectors);
        }

        public final List<QueryOutputVector.Builder> getVectors() {
            List<QueryOutputVector.Builder> result = QueryVectorsOutputListCopier.copyToBuilder(this.vectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVectors(Collection<QueryOutputVector.BuilderImpl> vectors) {
            this.vectors = QueryVectorsOutputListCopier.copyFromBuilder(vectors);
        }

        @Override
        public final Builder vectors(Collection<QueryOutputVector> vectors) {
            this.vectors = QueryVectorsOutputListCopier.copy(vectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectors(QueryOutputVector ... vectors) {
            this.vectors(Arrays.asList(vectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectors(Consumer<QueryOutputVector.Builder> ... vectors) {
            this.vectors(Stream.of(vectors).map(c -> (QueryOutputVector)((QueryOutputVector.Builder)QueryOutputVector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public QueryVectorsResponse build() {
            return new QueryVectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3VectorsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryVectorsResponse> {
        public Builder vectors(Collection<QueryOutputVector> var1);

        public Builder vectors(QueryOutputVector ... var1);

        public Builder vectors(Consumer<QueryOutputVector.Builder> ... var1);
    }
}

