/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsInputListCopier;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVectorsRequest
extends S3VectorsRequest
implements ToCopyableBuilder<Builder, GetVectorsRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketName").getter(GetVectorsRequest.getter(GetVectorsRequest::vectorBucketName)).setter(GetVectorsRequest.setter(Builder::vectorBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(GetVectorsRequest.getter(GetVectorsRequest::indexName)).setter(GetVectorsRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexArn").getter(GetVectorsRequest.getter(GetVectorsRequest::indexArn)).setter(GetVectorsRequest.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()}).build();
    private static final SdkField<List<String>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keys").getter(GetVectorsRequest.getter(GetVectorsRequest::keys)).setter(GetVectorsRequest.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RETURN_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("returnData").getter(GetVectorsRequest.getter(GetVectorsRequest::returnData)).setter(GetVectorsRequest.setter(Builder::returnData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnData").build()}).build();
    private static final SdkField<Boolean> RETURN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("returnMetadata").getter(GetVectorsRequest.getter(GetVectorsRequest::returnMetadata)).setter(GetVectorsRequest.setter(Builder::returnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD, INDEX_NAME_FIELD, INDEX_ARN_FIELD, KEYS_FIELD, RETURN_DATA_FIELD, RETURN_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetVectorsRequest.memberNameToFieldInitializer();
    private final String vectorBucketName;
    private final String indexName;
    private final String indexArn;
    private final List<String> keys;
    private final Boolean returnData;
    private final Boolean returnMetadata;

    private GetVectorsRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.keys = builder.keys;
        this.returnData = builder.returnData;
        this.returnMetadata = builder.returnMetadata;
    }

    public final String vectorBucketName() {
        return this.vectorBucketName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public final List<String> keys() {
        return this.keys;
    }

    public final Boolean returnData() {
        return this.returnData;
    }

    public final Boolean returnMetadata() {
        return this.returnMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnData());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVectorsRequest)) {
            return false;
        }
        GetVectorsRequest other = (GetVectorsRequest)((Object)obj);
        return Objects.equals(this.vectorBucketName(), other.vectorBucketName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexArn(), other.indexArn()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys()) && Objects.equals(this.returnData(), other.returnData()) && Objects.equals(this.returnMetadata(), other.returnMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetVectorsRequest").add("VectorBucketName", (Object)this.vectorBucketName()).add("IndexName", (Object)this.indexName()).add("IndexArn", (Object)this.indexArn()).add("Keys", this.hasKeys() ? this.keys() : null).add("ReturnData", (Object)this.returnData()).add("ReturnMetadata", (Object)this.returnMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vectorBucketName": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketName()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "indexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "returnData": {
                return Optional.ofNullable(clazz.cast(this.returnData()));
            }
            case "returnMetadata": {
                return Optional.ofNullable(clazz.cast(this.returnMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("keys", KEYS_FIELD);
        map.put("returnData", RETURN_DATA_FIELD);
        map.put("returnMetadata", RETURN_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVectorsRequest, T> g) {
        return obj -> g.apply((GetVectorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3VectorsRequest.BuilderImpl
    implements Builder {
        private String vectorBucketName;
        private String indexName;
        private String indexArn;
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();
        private Boolean returnData;
        private Boolean returnMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVectorsRequest model) {
            super(model);
            this.vectorBucketName(model.vectorBucketName);
            this.indexName(model.indexName);
            this.indexArn(model.indexArn);
            this.keys(model.keys);
            this.returnData(model.returnData);
            this.returnMetadata(model.returnMetadata);
        }

        public final String getVectorBucketName() {
            return this.vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Collection<String> getKeys() {
            if (this.keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = GetVectorsInputListCopier.copy(keys);
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = GetVectorsInputListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final Boolean getReturnData() {
            return this.returnData;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        public final Boolean getReturnMetadata() {
            return this.returnMetadata;
        }

        public final void setReturnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
        }

        @Override
        public final Builder returnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetVectorsRequest build() {
            return new GetVectorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3VectorsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVectorsRequest> {
        public Builder vectorBucketName(String var1);

        public Builder indexName(String var1);

        public Builder indexArn(String var1);

        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder returnData(Boolean var1);

        public Builder returnMetadata(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

