/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3vectors.model.DataType;
import software.amazon.awssdk.services.s3vectors.model.DistanceMetric;
import software.amazon.awssdk.services.s3vectors.model.MetadataConfiguration;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIndexRequest
extends S3VectorsRequest
implements ToCopyableBuilder<Builder, CreateIndexRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketName").getter(CreateIndexRequest.getter(CreateIndexRequest::vectorBucketName)).setter(CreateIndexRequest.setter(Builder::vectorBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()}).build();
    private static final SdkField<String> VECTOR_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketArn").getter(CreateIndexRequest.getter(CreateIndexRequest::vectorBucketArn)).setter(CreateIndexRequest.setter(Builder::vectorBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketArn").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(CreateIndexRequest.getter(CreateIndexRequest::indexName)).setter(CreateIndexRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(CreateIndexRequest.getter(CreateIndexRequest::dataTypeAsString)).setter(CreateIndexRequest.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Integer> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dimension").getter(CreateIndexRequest.getter(CreateIndexRequest::dimension)).setter(CreateIndexRequest.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimension").build()}).build();
    private static final SdkField<String> DISTANCE_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distanceMetric").getter(CreateIndexRequest.getter(CreateIndexRequest::distanceMetricAsString)).setter(CreateIndexRequest.setter(Builder::distanceMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distanceMetric").build()}).build();
    private static final SdkField<MetadataConfiguration> METADATA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadataConfiguration").getter(CreateIndexRequest.getter(CreateIndexRequest::metadataConfiguration)).setter(CreateIndexRequest.setter(Builder::metadataConfiguration)).constructor(MetadataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD, VECTOR_BUCKET_ARN_FIELD, INDEX_NAME_FIELD, DATA_TYPE_FIELD, DIMENSION_FIELD, DISTANCE_METRIC_FIELD, METADATA_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIndexRequest.memberNameToFieldInitializer();
    private final String vectorBucketName;
    private final String vectorBucketArn;
    private final String indexName;
    private final String dataType;
    private final Integer dimension;
    private final String distanceMetric;
    private final MetadataConfiguration metadataConfiguration;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.vectorBucketArn = builder.vectorBucketArn;
        this.indexName = builder.indexName;
        this.dataType = builder.dataType;
        this.dimension = builder.dimension;
        this.distanceMetric = builder.distanceMetric;
        this.metadataConfiguration = builder.metadataConfiguration;
    }

    public final String vectorBucketName() {
        return this.vectorBucketName;
    }

    public final String vectorBucketArn() {
        return this.vectorBucketArn;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final DataType dataType() {
        return DataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final Integer dimension() {
        return this.dimension;
    }

    public final DistanceMetric distanceMetric() {
        return DistanceMetric.fromValue(this.distanceMetric);
    }

    public final String distanceMetricAsString() {
        return this.distanceMetric;
    }

    public final MetadataConfiguration metadataConfiguration() {
        return this.metadataConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)((Object)obj);
        return Objects.equals(this.vectorBucketName(), other.vectorBucketName()) && Objects.equals(this.vectorBucketArn(), other.vectorBucketArn()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.dimension(), other.dimension()) && Objects.equals(this.distanceMetricAsString(), other.distanceMetricAsString()) && Objects.equals(this.metadataConfiguration(), other.metadataConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIndexRequest").add("VectorBucketName", (Object)this.vectorBucketName()).add("VectorBucketArn", (Object)this.vectorBucketArn()).add("IndexName", (Object)this.indexName()).add("DataType", (Object)this.dataTypeAsString()).add("Dimension", (Object)this.dimension()).add("DistanceMetric", (Object)this.distanceMetricAsString()).add("MetadataConfiguration", (Object)this.metadataConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vectorBucketName": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketName()));
            }
            case "vectorBucketArn": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketArn()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "dimension": {
                return Optional.ofNullable(clazz.cast(this.dimension()));
            }
            case "distanceMetric": {
                return Optional.ofNullable(clazz.cast(this.distanceMetricAsString()));
            }
            case "metadataConfiguration": {
                return Optional.ofNullable(clazz.cast(this.metadataConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("vectorBucketArn", VECTOR_BUCKET_ARN_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("dimension", DIMENSION_FIELD);
        map.put("distanceMetric", DISTANCE_METRIC_FIELD);
        map.put("metadataConfiguration", METADATA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexRequest, T> g) {
        return obj -> g.apply((CreateIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3VectorsRequest.BuilderImpl
    implements Builder {
        private String vectorBucketName;
        private String vectorBucketArn;
        private String indexName;
        private String dataType;
        private Integer dimension;
        private String distanceMetric;
        private MetadataConfiguration metadataConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            super(model);
            this.vectorBucketName(model.vectorBucketName);
            this.vectorBucketArn(model.vectorBucketArn);
            this.indexName(model.indexName);
            this.dataType(model.dataType);
            this.dimension(model.dimension);
            this.distanceMetric(model.distanceMetric);
            this.metadataConfiguration(model.metadataConfiguration);
        }

        public final String getVectorBucketName() {
            return this.vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getVectorBucketArn() {
            return this.vectorBucketArn;
        }

        public final void setVectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
        }

        @Override
        public final Builder vectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Integer getDimension() {
            return this.dimension;
        }

        public final void setDimension(Integer dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getDistanceMetric() {
            return this.distanceMetric;
        }

        public final void setDistanceMetric(String distanceMetric) {
            this.distanceMetric = distanceMetric;
        }

        @Override
        public final Builder distanceMetric(String distanceMetric) {
            this.distanceMetric = distanceMetric;
            return this;
        }

        @Override
        public final Builder distanceMetric(DistanceMetric distanceMetric) {
            this.distanceMetric(distanceMetric == null ? null : distanceMetric.toString());
            return this;
        }

        public final MetadataConfiguration.Builder getMetadataConfiguration() {
            return this.metadataConfiguration != null ? this.metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(MetadataConfiguration.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(MetadataConfiguration metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3VectorsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIndexRequest> {
        public Builder vectorBucketName(String var1);

        public Builder vectorBucketArn(String var1);

        public Builder indexName(String var1);

        public Builder dataType(String var1);

        public Builder dataType(DataType var1);

        public Builder dimension(Integer var1);

        public Builder distanceMetric(String var1);

        public Builder distanceMetric(DistanceMetric var1);

        public Builder metadataConfiguration(MetadataConfiguration var1);

        default public Builder metadataConfiguration(Consumer<MetadataConfiguration.Builder> metadataConfiguration) {
            return this.metadataConfiguration((MetadataConfiguration)((MetadataConfiguration.Builder)MetadataConfiguration.builder().applyMutation(metadataConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

