/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3vectors.model.ListOutputVector;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsOutputListCopier;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVectorsResponse
extends S3VectorsResponse
implements ToCopyableBuilder<Builder, ListVectorsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVectorsResponse.getter(ListVectorsResponse::nextToken)).setter(ListVectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ListOutputVector>> VECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vectors").getter(ListVectorsResponse.getter(ListVectorsResponse::vectors)).setter(ListVectorsResponse.setter(Builder::vectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListOutputVector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VECTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVectorsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ListOutputVector> vectors;

    private ListVectorsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vectors = builder.vectors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVectors() {
        return this.vectors != null && !(this.vectors instanceof SdkAutoConstructList);
    }

    public final List<ListOutputVector> vectors() {
        return this.vectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVectors() ? this.vectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVectorsResponse)) {
            return false;
        }
        ListVectorsResponse other = (ListVectorsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVectors() == other.hasVectors() && Objects.equals(this.vectors(), other.vectors());
    }

    public final String toString() {
        return ToString.builder((String)"ListVectorsResponse").add("NextToken", (Object)this.nextToken()).add("Vectors", this.hasVectors() ? this.vectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "vectors": {
                return Optional.ofNullable(clazz.cast(this.vectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("vectors", VECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVectorsResponse, T> g) {
        return obj -> g.apply((ListVectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3VectorsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListOutputVector> vectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVectorsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.vectors(model.vectors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListOutputVector.Builder> getVectors() {
            List<ListOutputVector.Builder> result = ListVectorsOutputListCopier.copyToBuilder(this.vectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVectors(Collection<ListOutputVector.BuilderImpl> vectors) {
            this.vectors = ListVectorsOutputListCopier.copyFromBuilder(vectors);
        }

        @Override
        public final Builder vectors(Collection<ListOutputVector> vectors) {
            this.vectors = ListVectorsOutputListCopier.copy(vectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectors(ListOutputVector ... vectors) {
            this.vectors(Arrays.asList(vectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectors(Consumer<ListOutputVector.Builder> ... vectors) {
            this.vectors(Stream.of(vectors).map(c -> (ListOutputVector)((ListOutputVector.Builder)ListOutputVector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVectorsResponse build() {
            return new ListVectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3VectorsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVectorsResponse> {
        public Builder nextToken(String var1);

        public Builder vectors(Collection<ListOutputVector> var1);

        public Builder vectors(ListOutputVector ... var1);

        public Builder vectors(Consumer<ListOutputVector.Builder> ... var1);
    }
}

