/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTableMetadataLocationRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, UpdateTableMetadataLocationRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(UpdateTableMetadataLocationRequest.getter(UpdateTableMetadataLocationRequest::tableBucketARN)).setter(UpdateTableMetadataLocationRequest.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(UpdateTableMetadataLocationRequest.getter(UpdateTableMetadataLocationRequest::namespace)).setter(UpdateTableMetadataLocationRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateTableMetadataLocationRequest.getter(UpdateTableMetadataLocationRequest::name)).setter(UpdateTableMetadataLocationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionToken").getter(UpdateTableMetadataLocationRequest.getter(UpdateTableMetadataLocationRequest::versionToken)).setter(UpdateTableMetadataLocationRequest.setter(Builder::versionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()}).build();
    private static final SdkField<String> METADATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadataLocation").getter(UpdateTableMetadataLocationRequest.getter(UpdateTableMetadataLocationRequest::metadataLocation)).setter(UpdateTableMetadataLocationRequest.setter(Builder::metadataLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, NAMESPACE_FIELD, NAME_FIELD, VERSION_TOKEN_FIELD, METADATA_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTableMetadataLocationRequest.memberNameToFieldInitializer();
    private final String tableBucketARN;
    private final String namespace;
    private final String name;
    private final String versionToken;
    private final String metadataLocation;

    private UpdateTableMetadataLocationRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.versionToken = builder.versionToken;
        this.metadataLocation = builder.metadataLocation;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String name() {
        return this.name;
    }

    public final String versionToken() {
        return this.versionToken;
    }

    public final String metadataLocation() {
        return this.metadataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableMetadataLocationRequest)) {
            return false;
        }
        UpdateTableMetadataLocationRequest other = (UpdateTableMetadataLocationRequest)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.versionToken(), other.versionToken()) && Objects.equals(this.metadataLocation(), other.metadataLocation());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTableMetadataLocationRequest").add("TableBucketARN", (Object)this.tableBucketARN()).add("Namespace", (Object)this.namespace()).add("Name", (Object)this.name()).add("VersionToken", (Object)this.versionToken()).add("MetadataLocation", (Object)this.metadataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "versionToken": {
                return Optional.ofNullable(clazz.cast(this.versionToken()));
            }
            case "metadataLocation": {
                return Optional.ofNullable(clazz.cast(this.metadataLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("versionToken", VERSION_TOKEN_FIELD);
        map.put("metadataLocation", METADATA_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableMetadataLocationRequest, T> g) {
        return obj -> g.apply((UpdateTableMetadataLocationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private String namespace;
        private String name;
        private String versionToken;
        private String metadataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableMetadataLocationRequest model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.namespace(model.namespace);
            this.name(model.name);
            this.versionToken(model.versionToken);
            this.metadataLocation(model.metadataLocation);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionToken() {
            return this.versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public final String getMetadataLocation() {
            return this.metadataLocation;
        }

        public final void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @Override
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableMetadataLocationRequest build() {
            return new UpdateTableMetadataLocationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTableMetadataLocationRequest> {
        public Builder tableBucketARN(String var1);

        public Builder namespace(String var1);

        public Builder name(String var1);

        public Builder versionToken(String var1);

        public Builder metadataLocation(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

