/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.LastSuccessfulReplicatedUpdate;
import software.amazon.awssdk.services.s3tables.model.ReplicationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationDestinationStatusModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationDestinationStatusModel> {
    private static final SdkField<String> REPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationStatus").getter(ReplicationDestinationStatusModel.getter(ReplicationDestinationStatusModel::replicationStatusAsString)).setter(ReplicationDestinationStatusModel.setter(Builder::replicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatus").build()}).build();
    private static final SdkField<String> DESTINATION_TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationTableBucketArn").getter(ReplicationDestinationStatusModel.getter(ReplicationDestinationStatusModel::destinationTableBucketArn)).setter(ReplicationDestinationStatusModel.setter(Builder::destinationTableBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTableBucketArn").build()}).build();
    private static final SdkField<String> DESTINATION_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationTableArn").getter(ReplicationDestinationStatusModel.getter(ReplicationDestinationStatusModel::destinationTableArn)).setter(ReplicationDestinationStatusModel.setter(Builder::destinationTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTableArn").build()}).build();
    private static final SdkField<LastSuccessfulReplicatedUpdate> LAST_SUCCESSFUL_REPLICATED_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastSuccessfulReplicatedUpdate").getter(ReplicationDestinationStatusModel.getter(ReplicationDestinationStatusModel::lastSuccessfulReplicatedUpdate)).setter(ReplicationDestinationStatusModel.setter(Builder::lastSuccessfulReplicatedUpdate)).constructor(LastSuccessfulReplicatedUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulReplicatedUpdate").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(ReplicationDestinationStatusModel.getter(ReplicationDestinationStatusModel::failureMessage)).setter(ReplicationDestinationStatusModel.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_STATUS_FIELD, DESTINATION_TABLE_BUCKET_ARN_FIELD, DESTINATION_TABLE_ARN_FIELD, LAST_SUCCESSFUL_REPLICATED_UPDATE_FIELD, FAILURE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicationDestinationStatusModel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String replicationStatus;
    private final String destinationTableBucketArn;
    private final String destinationTableArn;
    private final LastSuccessfulReplicatedUpdate lastSuccessfulReplicatedUpdate;
    private final String failureMessage;

    private ReplicationDestinationStatusModel(BuilderImpl builder) {
        this.replicationStatus = builder.replicationStatus;
        this.destinationTableBucketArn = builder.destinationTableBucketArn;
        this.destinationTableArn = builder.destinationTableArn;
        this.lastSuccessfulReplicatedUpdate = builder.lastSuccessfulReplicatedUpdate;
        this.failureMessage = builder.failureMessage;
    }

    public final ReplicationStatus replicationStatus() {
        return ReplicationStatus.fromValue(this.replicationStatus);
    }

    public final String replicationStatusAsString() {
        return this.replicationStatus;
    }

    public final String destinationTableBucketArn() {
        return this.destinationTableBucketArn;
    }

    public final String destinationTableArn() {
        return this.destinationTableArn;
    }

    public final LastSuccessfulReplicatedUpdate lastSuccessfulReplicatedUpdate() {
        return this.lastSuccessfulReplicatedUpdate;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTableBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulReplicatedUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationDestinationStatusModel)) {
            return false;
        }
        ReplicationDestinationStatusModel other = (ReplicationDestinationStatusModel)obj;
        return Objects.equals(this.replicationStatusAsString(), other.replicationStatusAsString()) && Objects.equals(this.destinationTableBucketArn(), other.destinationTableBucketArn()) && Objects.equals(this.destinationTableArn(), other.destinationTableArn()) && Objects.equals(this.lastSuccessfulReplicatedUpdate(), other.lastSuccessfulReplicatedUpdate()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationDestinationStatusModel").add("ReplicationStatus", (Object)this.replicationStatusAsString()).add("DestinationTableBucketArn", (Object)this.destinationTableBucketArn()).add("DestinationTableArn", (Object)this.destinationTableArn()).add("LastSuccessfulReplicatedUpdate", (Object)this.lastSuccessfulReplicatedUpdate()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationStatus": {
                return Optional.ofNullable(clazz.cast(this.replicationStatusAsString()));
            }
            case "destinationTableBucketArn": {
                return Optional.ofNullable(clazz.cast(this.destinationTableBucketArn()));
            }
            case "destinationTableArn": {
                return Optional.ofNullable(clazz.cast(this.destinationTableArn()));
            }
            case "lastSuccessfulReplicatedUpdate": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulReplicatedUpdate()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("replicationStatus", REPLICATION_STATUS_FIELD);
        map.put("destinationTableBucketArn", DESTINATION_TABLE_BUCKET_ARN_FIELD);
        map.put("destinationTableArn", DESTINATION_TABLE_ARN_FIELD);
        map.put("lastSuccessfulReplicatedUpdate", LAST_SUCCESSFUL_REPLICATED_UPDATE_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationDestinationStatusModel, T> g) {
        return obj -> g.apply((ReplicationDestinationStatusModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationStatus;
        private String destinationTableBucketArn;
        private String destinationTableArn;
        private LastSuccessfulReplicatedUpdate lastSuccessfulReplicatedUpdate;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationDestinationStatusModel model) {
            this.replicationStatus(model.replicationStatus);
            this.destinationTableBucketArn(model.destinationTableBucketArn);
            this.destinationTableArn(model.destinationTableArn);
            this.lastSuccessfulReplicatedUpdate(model.lastSuccessfulReplicatedUpdate);
            this.failureMessage(model.failureMessage);
        }

        public final String getReplicationStatus() {
            return this.replicationStatus;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(ReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus == null ? null : replicationStatus.toString());
            return this;
        }

        public final String getDestinationTableBucketArn() {
            return this.destinationTableBucketArn;
        }

        public final void setDestinationTableBucketArn(String destinationTableBucketArn) {
            this.destinationTableBucketArn = destinationTableBucketArn;
        }

        @Override
        public final Builder destinationTableBucketArn(String destinationTableBucketArn) {
            this.destinationTableBucketArn = destinationTableBucketArn;
            return this;
        }

        public final String getDestinationTableArn() {
            return this.destinationTableArn;
        }

        public final void setDestinationTableArn(String destinationTableArn) {
            this.destinationTableArn = destinationTableArn;
        }

        @Override
        public final Builder destinationTableArn(String destinationTableArn) {
            this.destinationTableArn = destinationTableArn;
            return this;
        }

        public final LastSuccessfulReplicatedUpdate.Builder getLastSuccessfulReplicatedUpdate() {
            return this.lastSuccessfulReplicatedUpdate != null ? this.lastSuccessfulReplicatedUpdate.toBuilder() : null;
        }

        public final void setLastSuccessfulReplicatedUpdate(LastSuccessfulReplicatedUpdate.BuilderImpl lastSuccessfulReplicatedUpdate) {
            this.lastSuccessfulReplicatedUpdate = lastSuccessfulReplicatedUpdate != null ? lastSuccessfulReplicatedUpdate.build() : null;
        }

        @Override
        public final Builder lastSuccessfulReplicatedUpdate(LastSuccessfulReplicatedUpdate lastSuccessfulReplicatedUpdate) {
            this.lastSuccessfulReplicatedUpdate = lastSuccessfulReplicatedUpdate;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public ReplicationDestinationStatusModel build() {
            return new ReplicationDestinationStatusModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationDestinationStatusModel> {
        public Builder replicationStatus(String var1);

        public Builder replicationStatus(ReplicationStatus var1);

        public Builder destinationTableBucketArn(String var1);

        public Builder destinationTableArn(String var1);

        public Builder lastSuccessfulReplicatedUpdate(LastSuccessfulReplicatedUpdate var1);

        default public Builder lastSuccessfulReplicatedUpdate(Consumer<LastSuccessfulReplicatedUpdate.Builder> lastSuccessfulReplicatedUpdate) {
            return this.lastSuccessfulReplicatedUpdate((LastSuccessfulReplicatedUpdate)((LastSuccessfulReplicatedUpdate.Builder)LastSuccessfulReplicatedUpdate.builder().applyMutation(lastSuccessfulReplicatedUpdate)).build());
        }

        public Builder failureMessage(String var1);
    }
}

