/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.IcebergSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergMetadata> {
    private static final SdkField<IcebergSchema> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schema").getter(IcebergMetadata.getter(IcebergMetadata::schema)).setter(IcebergMetadata.setter(Builder::schema)).constructor(IcebergSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IcebergSchema schema;

    private IcebergMetadata(BuilderImpl builder) {
        this.schema = builder.schema;
    }

    public final IcebergSchema schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergMetadata)) {
            return false;
        }
        IcebergMetadata other = (IcebergMetadata)obj;
        return Objects.equals(this.schema(), other.schema());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergMetadata").add("Schema", (Object)this.schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<IcebergSchema>> map = new HashMap<String, SdkField<IcebergSchema>>();
        map.put("schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergMetadata, T> g) {
        return obj -> g.apply((IcebergMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IcebergSchema schema;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergMetadata model) {
            this.schema(model.schema);
        }

        public final IcebergSchema.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(IcebergSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(IcebergSchema schema) {
            this.schema = schema;
            return this;
        }

        public IcebergMetadata build() {
            return new IcebergMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergMetadata> {
        public Builder schema(IcebergSchema var1);

        default public Builder schema(Consumer<IcebergSchema.Builder> schema) {
            return this.schema((IcebergSchema)((IcebergSchema.Builder)IcebergSchema.builder().applyMutation(schema)).build());
        }
    }
}

