/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTablesRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, ListTablesRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(ListTablesRequest.getter(ListTablesRequest::tableBucketARN)).setter(ListTablesRequest.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ListTablesRequest.getter(ListTablesRequest::namespace)).setter(ListTablesRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(ListTablesRequest.getter(ListTablesRequest::prefix)).setter(ListTablesRequest.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("prefix").build()}).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continuationToken").getter(ListTablesRequest.getter(ListTablesRequest::continuationToken)).setter(ListTablesRequest.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continuationToken").build()}).build();
    private static final SdkField<Integer> MAX_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxTables").getter(ListTablesRequest.getter(ListTablesRequest::maxTables)).setter(ListTablesRequest.setter(Builder::maxTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxTables").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, NAMESPACE_FIELD, PREFIX_FIELD, CONTINUATION_TOKEN_FIELD, MAX_TABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTablesRequest.memberNameToFieldInitializer();
    private final String tableBucketARN;
    private final String namespace;
    private final String prefix;
    private final String continuationToken;
    private final Integer maxTables;

    private ListTablesRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
        this.prefix = builder.prefix;
        this.continuationToken = builder.continuationToken;
        this.maxTables = builder.maxTables;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public final Integer maxTables() {
        return this.maxTables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTables());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesRequest)) {
            return false;
        }
        ListTablesRequest other = (ListTablesRequest)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.maxTables(), other.maxTables());
    }

    public final String toString() {
        return ToString.builder((String)"ListTablesRequest").add("TableBucketARN", (Object)this.tableBucketARN()).add("Namespace", (Object)this.namespace()).add("Prefix", (Object)this.prefix()).add("ContinuationToken", (Object)this.continuationToken()).add("MaxTables", (Object)this.maxTables()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "continuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "maxTables": {
                return Optional.ofNullable(clazz.cast(this.maxTables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("prefix", PREFIX_FIELD);
        map.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        map.put("maxTables", MAX_TABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTablesRequest, T> g) {
        return obj -> g.apply((ListTablesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private String namespace;
        private String prefix;
        private String continuationToken;
        private Integer maxTables;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesRequest model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.namespace(model.namespace);
            this.prefix(model.prefix);
            this.continuationToken(model.continuationToken);
            this.maxTables(model.maxTables);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final Integer getMaxTables() {
            return this.maxTables;
        }

        public final void setMaxTables(Integer maxTables) {
            this.maxTables = maxTables;
        }

        @Override
        public final Builder maxTables(Integer maxTables) {
            this.maxTables = maxTables;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTablesRequest build() {
            return new ListTablesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTablesRequest> {
        public Builder tableBucketARN(String var1);

        public Builder namespace(String var1);

        public Builder prefix(String var1);

        public Builder continuationToken(String var1);

        public Builder maxTables(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

