/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3tables.model.NamespaceListCopier;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNamespaceResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, GetNamespaceResponse> {
    private static final SdkField<List<String>> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespace").getter(GetNamespaceResponse.getter(GetNamespaceResponse::namespace)).setter(GetNamespaceResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetNamespaceResponse.getter(GetNamespaceResponse::createdAt)).setter(GetNamespaceResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetNamespaceResponse.getter(GetNamespaceResponse::createdBy)).setter(GetNamespaceResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccountId").getter(GetNamespaceResponse.getter(GetNamespaceResponse::ownerAccountId)).setter(GetNamespaceResponse.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()}).build();
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceId").getter(GetNamespaceResponse.getter(GetNamespaceResponse::namespaceId)).setter(GetNamespaceResponse.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceId").build()}).build();
    private static final SdkField<String> TABLE_BUCKET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketId").getter(GetNamespaceResponse.getter(GetNamespaceResponse::tableBucketId)).setter(GetNamespaceResponse.setter(Builder::tableBucketId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableBucketId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, OWNER_ACCOUNT_ID_FIELD, NAMESPACE_ID_FIELD, TABLE_BUCKET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetNamespaceResponse.memberNameToFieldInitializer();
    private final List<String> namespace;
    private final Instant createdAt;
    private final String createdBy;
    private final String ownerAccountId;
    private final String namespaceId;
    private final String tableBucketId;

    private GetNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.ownerAccountId = builder.ownerAccountId;
        this.namespaceId = builder.namespaceId;
        this.tableBucketId = builder.tableBucketId;
    }

    public final boolean hasNamespace() {
        return this.namespace != null && !(this.namespace instanceof SdkAutoConstructList);
    }

    public final List<String> namespace() {
        return this.namespace;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String namespaceId() {
        return this.namespaceId;
    }

    public final String tableBucketId() {
        return this.tableBucketId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespace() ? this.namespace() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamespaceResponse)) {
            return false;
        }
        GetNamespaceResponse other = (GetNamespaceResponse)((Object)obj);
        return this.hasNamespace() == other.hasNamespace() && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.tableBucketId(), other.tableBucketId());
    }

    public final String toString() {
        return ToString.builder((String)"GetNamespaceResponse").add("Namespace", this.hasNamespace() ? this.namespace() : null).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("NamespaceId", (Object)this.namespaceId()).add("TableBucketId", (Object)this.tableBucketId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ownerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "namespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
            case "tableBucketId": {
                return Optional.ofNullable(clazz.cast(this.tableBucketId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("namespaceId", NAMESPACE_ID_FIELD);
        map.put("tableBucketId", TABLE_BUCKET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNamespaceResponse, T> g) {
        return obj -> g.apply((GetNamespaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private List<String> namespace = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String createdBy;
        private String ownerAccountId;
        private String namespaceId;
        private String tableBucketId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamespaceResponse model) {
            super(model);
            this.namespace(model.namespace);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.ownerAccountId(model.ownerAccountId);
            this.namespaceId(model.namespaceId);
            this.tableBucketId(model.tableBucketId);
        }

        public final Collection<String> getNamespace() {
            if (this.namespace instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespace;
        }

        public final void setNamespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
        }

        @Override
        public final Builder namespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespace(String ... namespace) {
            this.namespace(Arrays.asList(namespace));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getTableBucketId() {
            return this.tableBucketId;
        }

        public final void setTableBucketId(String tableBucketId) {
            this.tableBucketId = tableBucketId;
        }

        @Override
        public final Builder tableBucketId(String tableBucketId) {
            this.tableBucketId = tableBucketId;
            return this;
        }

        @Override
        public GetNamespaceResponse build() {
            return new GetNamespaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNamespaceResponse> {
        public Builder namespace(Collection<String> var1);

        public Builder namespace(String ... var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder ownerAccountId(String var1);

        public Builder namespaceId(String var1);

        public Builder tableBucketId(String var1);
    }
}

