/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3tables.S3TablesAsyncClient;
import software.amazon.awssdk.services.s3tables.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest;
import software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse;
import software.amazon.awssdk.services.s3tables.model.NamespaceSummary;

public class ListNamespacesPublisher
implements SdkPublisher<ListNamespacesResponse> {
    private final S3TablesAsyncClient client;
    private final ListNamespacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNamespacesPublisher(S3TablesAsyncClient client, ListNamespacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNamespacesPublisher(S3TablesAsyncClient client, ListNamespacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNamespacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNamespacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NamespaceSummary> namespaces() {
        Function<ListNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.namespaces() != null) {
                return response.namespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNamespacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNamespacesResponseFetcher
    implements AsyncPageFetcher<ListNamespacesResponse> {
        private ListNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.continuationToken());
        }

        public CompletableFuture<ListNamespacesResponse> nextPage(ListNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListNamespacesPublisher.this.client.listNamespaces(ListNamespacesPublisher.this.firstRequest);
            }
            return ListNamespacesPublisher.this.client.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesPublisher.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build()));
        }
    }
}

