/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3tables.S3TablesClient;
import software.amazon.awssdk.services.s3tables.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest;
import software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse;
import software.amazon.awssdk.services.s3tables.model.NamespaceSummary;

public class ListNamespacesIterable
implements SdkIterable<ListNamespacesResponse> {
    private final S3TablesClient client;
    private final ListNamespacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNamespacesIterable(S3TablesClient client, ListNamespacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNamespacesResponseFetcher();
    }

    public Iterator<ListNamespacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NamespaceSummary> namespaces() {
        Function<ListNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.namespaces() != null) {
                return response.namespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNamespacesResponseFetcher
    implements SyncPageFetcher<ListNamespacesResponse> {
        private ListNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.continuationToken());
        }

        public ListNamespacesResponse nextPage(ListNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListNamespacesIterable.this.client.listNamespaces(ListNamespacesIterable.this.firstRequest);
            }
            return ListNamespacesIterable.this.client.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesIterable.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build()));
        }
    }
}

