/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTableResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, CreateTableResponse> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableARN").getter(CreateTableResponse.getter(CreateTableResponse::tableARN)).setter(CreateTableResponse.setter(Builder::tableARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()}).build();
    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionToken").getter(CreateTableResponse.getter(CreateTableResponse::versionToken)).setter(CreateTableResponse.setter(Builder::versionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD, VERSION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTableResponse.memberNameToFieldInitializer();
    private final String tableARN;
    private final String versionToken;

    private CreateTableResponse(BuilderImpl builder) {
        super(builder);
        this.tableARN = builder.tableARN;
        this.versionToken = builder.versionToken;
    }

    public final String tableARN() {
        return this.tableARN;
    }

    public final String versionToken() {
        return this.versionToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableResponse)) {
            return false;
        }
        CreateTableResponse other = (CreateTableResponse)((Object)obj);
        return Objects.equals(this.tableARN(), other.tableARN()) && Objects.equals(this.versionToken(), other.versionToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTableResponse").add("TableARN", (Object)this.tableARN()).add("VersionToken", (Object)this.versionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableARN": {
                return Optional.ofNullable(clazz.cast(this.tableARN()));
            }
            case "versionToken": {
                return Optional.ofNullable(clazz.cast(this.versionToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("tableARN", TABLE_ARN_FIELD);
        map.put("versionToken", VERSION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTableResponse, T> g) {
        return obj -> g.apply((CreateTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String tableARN;
        private String versionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableResponse model) {
            super(model);
            this.tableARN(model.tableARN);
            this.versionToken(model.versionToken);
        }

        public final String getTableARN() {
            return this.tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final String getVersionToken() {
            return this.versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        @Override
        public CreateTableResponse build() {
            return new CreateTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTableResponse> {
        public Builder tableARN(String var1);

        public Builder versionToken(String var1);
    }
}

