/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3tables.model.IcebergCompactionSettings;
import software.amazon.awssdk.services.s3tables.model.IcebergSnapshotManagementSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableMaintenanceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableMaintenanceSettings> {
    private static final SdkField<IcebergCompactionSettings> ICEBERG_COMPACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("icebergCompaction").getter(TableMaintenanceSettings.getter(TableMaintenanceSettings::icebergCompaction)).setter(TableMaintenanceSettings.setter(Builder::icebergCompaction)).constructor(IcebergCompactionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("icebergCompaction").build()}).build();
    private static final SdkField<IcebergSnapshotManagementSettings> ICEBERG_SNAPSHOT_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("icebergSnapshotManagement").getter(TableMaintenanceSettings.getter(TableMaintenanceSettings::icebergSnapshotManagement)).setter(TableMaintenanceSettings.setter(Builder::icebergSnapshotManagement)).constructor(IcebergSnapshotManagementSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("icebergSnapshotManagement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICEBERG_COMPACTION_FIELD, ICEBERG_SNAPSHOT_MANAGEMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("icebergCompaction", ICEBERG_COMPACTION_FIELD);
            this.put("icebergSnapshotManagement", ICEBERG_SNAPSHOT_MANAGEMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final IcebergCompactionSettings icebergCompaction;
    private final IcebergSnapshotManagementSettings icebergSnapshotManagement;
    private final Type type;

    private TableMaintenanceSettings(BuilderImpl builder) {
        this.icebergCompaction = builder.icebergCompaction;
        this.icebergSnapshotManagement = builder.icebergSnapshotManagement;
        this.type = builder.type;
    }

    public final IcebergCompactionSettings icebergCompaction() {
        return this.icebergCompaction;
    }

    public final IcebergSnapshotManagementSettings icebergSnapshotManagement() {
        return this.icebergSnapshotManagement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.icebergCompaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.icebergSnapshotManagement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMaintenanceSettings)) {
            return false;
        }
        TableMaintenanceSettings other = (TableMaintenanceSettings)obj;
        return Objects.equals(this.icebergCompaction(), other.icebergCompaction()) && Objects.equals(this.icebergSnapshotManagement(), other.icebergSnapshotManagement());
    }

    public final String toString() {
        return ToString.builder((String)"TableMaintenanceSettings").add("IcebergCompaction", (Object)this.icebergCompaction()).add("IcebergSnapshotManagement", (Object)this.icebergSnapshotManagement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "icebergCompaction": {
                return Optional.ofNullable(clazz.cast(this.icebergCompaction()));
            }
            case "icebergSnapshotManagement": {
                return Optional.ofNullable(clazz.cast(this.icebergSnapshotManagement()));
            }
        }
        return Optional.empty();
    }

    public static TableMaintenanceSettings fromIcebergCompaction(IcebergCompactionSettings icebergCompaction) {
        return (TableMaintenanceSettings)TableMaintenanceSettings.builder().icebergCompaction(icebergCompaction).build();
    }

    public static TableMaintenanceSettings fromIcebergCompaction(Consumer<IcebergCompactionSettings.Builder> icebergCompaction) {
        IcebergCompactionSettings.Builder builder = IcebergCompactionSettings.builder();
        icebergCompaction.accept(builder);
        return TableMaintenanceSettings.fromIcebergCompaction((IcebergCompactionSettings)builder.build());
    }

    public static TableMaintenanceSettings fromIcebergSnapshotManagement(IcebergSnapshotManagementSettings icebergSnapshotManagement) {
        return (TableMaintenanceSettings)TableMaintenanceSettings.builder().icebergSnapshotManagement(icebergSnapshotManagement).build();
    }

    public static TableMaintenanceSettings fromIcebergSnapshotManagement(Consumer<IcebergSnapshotManagementSettings.Builder> icebergSnapshotManagement) {
        IcebergSnapshotManagementSettings.Builder builder = IcebergSnapshotManagementSettings.builder();
        icebergSnapshotManagement.accept(builder);
        return TableMaintenanceSettings.fromIcebergSnapshotManagement((IcebergSnapshotManagementSettings)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableMaintenanceSettings, T> g) {
        return obj -> g.apply((TableMaintenanceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ICEBERG_COMPACTION,
        ICEBERG_SNAPSHOT_MANAGEMENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IcebergCompactionSettings icebergCompaction;
        private IcebergSnapshotManagementSettings icebergSnapshotManagement;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableMaintenanceSettings model) {
            this.icebergCompaction(model.icebergCompaction);
            this.icebergSnapshotManagement(model.icebergSnapshotManagement);
        }

        public final IcebergCompactionSettings.Builder getIcebergCompaction() {
            return this.icebergCompaction != null ? this.icebergCompaction.toBuilder() : null;
        }

        public final void setIcebergCompaction(IcebergCompactionSettings.BuilderImpl icebergCompaction) {
            IcebergCompactionSettings oldValue = this.icebergCompaction;
            this.icebergCompaction = icebergCompaction != null ? icebergCompaction.build() : null;
            this.handleUnionValueChange(Type.ICEBERG_COMPACTION, oldValue, this.icebergCompaction);
        }

        @Override
        public final Builder icebergCompaction(IcebergCompactionSettings icebergCompaction) {
            IcebergCompactionSettings oldValue = this.icebergCompaction;
            this.icebergCompaction = icebergCompaction;
            this.handleUnionValueChange(Type.ICEBERG_COMPACTION, oldValue, this.icebergCompaction);
            return this;
        }

        public final IcebergSnapshotManagementSettings.Builder getIcebergSnapshotManagement() {
            return this.icebergSnapshotManagement != null ? this.icebergSnapshotManagement.toBuilder() : null;
        }

        public final void setIcebergSnapshotManagement(IcebergSnapshotManagementSettings.BuilderImpl icebergSnapshotManagement) {
            IcebergSnapshotManagementSettings oldValue = this.icebergSnapshotManagement;
            this.icebergSnapshotManagement = icebergSnapshotManagement != null ? icebergSnapshotManagement.build() : null;
            this.handleUnionValueChange(Type.ICEBERG_SNAPSHOT_MANAGEMENT, oldValue, this.icebergSnapshotManagement);
        }

        @Override
        public final Builder icebergSnapshotManagement(IcebergSnapshotManagementSettings icebergSnapshotManagement) {
            IcebergSnapshotManagementSettings oldValue = this.icebergSnapshotManagement;
            this.icebergSnapshotManagement = icebergSnapshotManagement;
            this.handleUnionValueChange(Type.ICEBERG_SNAPSHOT_MANAGEMENT, oldValue, this.icebergSnapshotManagement);
            return this;
        }

        public TableMaintenanceSettings build() {
            return new TableMaintenanceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableMaintenanceSettings> {
        public Builder icebergCompaction(IcebergCompactionSettings var1);

        default public Builder icebergCompaction(Consumer<IcebergCompactionSettings.Builder> icebergCompaction) {
            return this.icebergCompaction((IcebergCompactionSettings)((IcebergCompactionSettings.Builder)IcebergCompactionSettings.builder().applyMutation(icebergCompaction)).build());
        }

        public Builder icebergSnapshotManagement(IcebergSnapshotManagementSettings var1);

        default public Builder icebergSnapshotManagement(Consumer<IcebergSnapshotManagementSettings.Builder> icebergSnapshotManagement) {
            return this.icebergSnapshotManagement((IcebergSnapshotManagementSettings)((IcebergSnapshotManagementSettings.Builder)IcebergSnapshotManagementSettings.builder().applyMutation(icebergSnapshotManagement)).build());
        }
    }
}

