/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTableBucketPolicyRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, PutTableBucketPolicyRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(PutTableBucketPolicyRequest.getter(PutTableBucketPolicyRequest::tableBucketARN)).setter(PutTableBucketPolicyRequest.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()}).build();
    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourcePolicy").getter(PutTableBucketPolicyRequest.getter(PutTableBucketPolicyRequest::resourcePolicy)).setter(PutTableBucketPolicyRequest.setter(Builder::resourcePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, RESOURCE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
            this.put("resourcePolicy", RESOURCE_POLICY_FIELD);
        }
    });
    private final String tableBucketARN;
    private final String resourcePolicy;

    private PutTableBucketPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.resourcePolicy = builder.resourcePolicy;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final String resourcePolicy() {
        return this.resourcePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTableBucketPolicyRequest)) {
            return false;
        }
        PutTableBucketPolicyRequest other = (PutTableBucketPolicyRequest)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && Objects.equals(this.resourcePolicy(), other.resourcePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutTableBucketPolicyRequest").add("TableBucketARN", (Object)this.tableBucketARN()).add("ResourcePolicy", (Object)this.resourcePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "resourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutTableBucketPolicyRequest, T> g) {
        return obj -> g.apply((PutTableBucketPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private String resourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTableBucketPolicyRequest model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.resourcePolicy(model.resourcePolicy);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getResourcePolicy() {
            return this.resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTableBucketPolicyRequest build() {
            return new PutTableBucketPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTableBucketPolicyRequest> {
        public Builder tableBucketARN(String var1);

        public Builder resourcePolicy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

