/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.services.s3tables.model.TableBucketSummary;
import software.amazon.awssdk.services.s3tables.model.TableBucketSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTableBucketsResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, ListTableBucketsResponse> {
    private static final SdkField<List<TableBucketSummary>> TABLE_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tableBuckets").getter(ListTableBucketsResponse.getter(ListTableBucketsResponse::tableBuckets)).setter(ListTableBucketsResponse.setter(Builder::tableBuckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableBuckets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableBucketSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continuationToken").getter(ListTableBucketsResponse.getter(ListTableBucketsResponse::continuationToken)).setter(ListTableBucketsResponse.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKETS_FIELD, CONTINUATION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tableBuckets", TABLE_BUCKETS_FIELD);
            this.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        }
    });
    private final List<TableBucketSummary> tableBuckets;
    private final String continuationToken;

    private ListTableBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.tableBuckets = builder.tableBuckets;
        this.continuationToken = builder.continuationToken;
    }

    public final boolean hasTableBuckets() {
        return this.tableBuckets != null && !(this.tableBuckets instanceof SdkAutoConstructList);
    }

    public final List<TableBucketSummary> tableBuckets() {
        return this.tableBuckets;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableBuckets() ? this.tableBuckets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableBucketsResponse)) {
            return false;
        }
        ListTableBucketsResponse other = (ListTableBucketsResponse)((Object)obj);
        return this.hasTableBuckets() == other.hasTableBuckets() && Objects.equals(this.tableBuckets(), other.tableBuckets()) && Objects.equals(this.continuationToken(), other.continuationToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTableBucketsResponse").add("TableBuckets", this.hasTableBuckets() ? this.tableBuckets() : null).add("ContinuationToken", (Object)this.continuationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBuckets": {
                return Optional.ofNullable(clazz.cast(this.tableBuckets()));
            }
            case "continuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTableBucketsResponse, T> g) {
        return obj -> g.apply((ListTableBucketsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private List<TableBucketSummary> tableBuckets = DefaultSdkAutoConstructList.getInstance();
        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableBucketsResponse model) {
            super(model);
            this.tableBuckets(model.tableBuckets);
            this.continuationToken(model.continuationToken);
        }

        public final List<TableBucketSummary.Builder> getTableBuckets() {
            List<TableBucketSummary.Builder> result = TableBucketSummaryListCopier.copyToBuilder(this.tableBuckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableBuckets(Collection<TableBucketSummary.BuilderImpl> tableBuckets) {
            this.tableBuckets = TableBucketSummaryListCopier.copyFromBuilder(tableBuckets);
        }

        @Override
        public final Builder tableBuckets(Collection<TableBucketSummary> tableBuckets) {
            this.tableBuckets = TableBucketSummaryListCopier.copy(tableBuckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableBuckets(TableBucketSummary ... tableBuckets) {
            this.tableBuckets(Arrays.asList(tableBuckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableBuckets(Consumer<TableBucketSummary.Builder> ... tableBuckets) {
            this.tableBuckets(Stream.of(tableBuckets).map(c -> (TableBucketSummary)((TableBucketSummary.Builder)TableBucketSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        @Override
        public ListTableBucketsResponse build() {
            return new ListTableBucketsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTableBucketsResponse> {
        public Builder tableBuckets(Collection<TableBucketSummary> var1);

        public Builder tableBuckets(TableBucketSummary ... var1);

        public Builder tableBuckets(Consumer<TableBucketSummary.Builder> ... var1);

        public Builder continuationToken(String var1);
    }
}

