/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNamespacesRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, ListNamespacesRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(ListNamespacesRequest.getter(ListNamespacesRequest::tableBucketARN)).setter(ListNamespacesRequest.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(ListNamespacesRequest.getter(ListNamespacesRequest::prefix)).setter(ListNamespacesRequest.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("prefix").build()}).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continuationToken").getter(ListNamespacesRequest.getter(ListNamespacesRequest::continuationToken)).setter(ListNamespacesRequest.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continuationToken").build()}).build();
    private static final SdkField<Integer> MAX_NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxNamespaces").getter(ListNamespacesRequest.getter(ListNamespacesRequest::maxNamespaces)).setter(ListNamespacesRequest.setter(Builder::maxNamespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxNamespaces").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, PREFIX_FIELD, CONTINUATION_TOKEN_FIELD, MAX_NAMESPACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
            this.put("prefix", PREFIX_FIELD);
            this.put("continuationToken", CONTINUATION_TOKEN_FIELD);
            this.put("maxNamespaces", MAX_NAMESPACES_FIELD);
        }
    });
    private final String tableBucketARN;
    private final String prefix;
    private final String continuationToken;
    private final Integer maxNamespaces;

    private ListNamespacesRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.prefix = builder.prefix;
        this.continuationToken = builder.continuationToken;
        this.maxNamespaces = builder.maxNamespaces;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public final Integer maxNamespaces() {
        return this.maxNamespaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNamespaces());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamespacesRequest)) {
            return false;
        }
        ListNamespacesRequest other = (ListNamespacesRequest)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.maxNamespaces(), other.maxNamespaces());
    }

    public final String toString() {
        return ToString.builder((String)"ListNamespacesRequest").add("TableBucketARN", (Object)this.tableBucketARN()).add("Prefix", (Object)this.prefix()).add("ContinuationToken", (Object)this.continuationToken()).add("MaxNamespaces", (Object)this.maxNamespaces()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "continuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "maxNamespaces": {
                return Optional.ofNullable(clazz.cast(this.maxNamespaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNamespacesRequest, T> g) {
        return obj -> g.apply((ListNamespacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private String prefix;
        private String continuationToken;
        private Integer maxNamespaces;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamespacesRequest model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.prefix(model.prefix);
            this.continuationToken(model.continuationToken);
            this.maxNamespaces(model.maxNamespaces);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final Integer getMaxNamespaces() {
            return this.maxNamespaces;
        }

        public final void setMaxNamespaces(Integer maxNamespaces) {
            this.maxNamespaces = maxNamespaces;
        }

        @Override
        public final Builder maxNamespaces(Integer maxNamespaces) {
            this.maxNamespaces = maxNamespaces;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNamespacesRequest build() {
            return new ListNamespacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNamespacesRequest> {
        public Builder tableBucketARN(String var1);

        public Builder prefix(String var1);

        public Builder continuationToken(String var1);

        public Builder maxNamespaces(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

