/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3outposts.model.EndpointAccessType;
import software.amazon.awssdk.services.s3outposts.model.EndpointStatus;
import software.amazon.awssdk.services.s3outposts.model.FailedReason;
import software.amazon.awssdk.services.s3outposts.model.NetworkInterface;
import software.amazon.awssdk.services.s3outposts.model.NetworkInterfacesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Endpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Endpoint> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(Endpoint.getter(Endpoint::endpointArn)).setter(Endpoint.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> OUTPOSTS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostsId").getter(Endpoint.getter(Endpoint::outpostsId)).setter(Endpoint.setter(Builder::outpostsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostsId").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(Endpoint.getter(Endpoint::cidrBlock)).setter(Endpoint.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Endpoint.getter(Endpoint::statusAsString)).setter(Endpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Endpoint.getter(Endpoint::creationTime)).setter(Endpoint.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(Endpoint.getter(Endpoint::networkInterfaces)).setter(Endpoint.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Endpoint.getter(Endpoint::vpcId)).setter(Endpoint.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(Endpoint.getter(Endpoint::subnetId)).setter(Endpoint.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupId").getter(Endpoint.getter(Endpoint::securityGroupId)).setter(Endpoint.setter(Builder::securityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build();
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessType").getter(Endpoint.getter(Endpoint::accessTypeAsString)).setter(Endpoint.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(Endpoint.getter(Endpoint::customerOwnedIpv4Pool)).setter(Endpoint.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").build()}).build();
    private static final SdkField<FailedReason> FAILED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailedReason").getter(Endpoint.getter(Endpoint::failedReason)).setter(Endpoint.setter(Builder::failedReason)).constructor(FailedReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD, OUTPOSTS_ID_FIELD, CIDR_BLOCK_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, NETWORK_INTERFACES_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, SECURITY_GROUP_ID_FIELD, ACCESS_TYPE_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, FAILED_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointArn", ENDPOINT_ARN_FIELD);
            this.put("OutpostsId", OUTPOSTS_ID_FIELD);
            this.put("CidrBlock", CIDR_BLOCK_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("NetworkInterfaces", NETWORK_INTERFACES_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("SubnetId", SUBNET_ID_FIELD);
            this.put("SecurityGroupId", SECURITY_GROUP_ID_FIELD);
            this.put("AccessType", ACCESS_TYPE_FIELD);
            this.put("CustomerOwnedIpv4Pool", CUSTOMER_OWNED_IPV4_POOL_FIELD);
            this.put("FailedReason", FAILED_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String endpointArn;
    private final String outpostsId;
    private final String cidrBlock;
    private final String status;
    private final Instant creationTime;
    private final List<NetworkInterface> networkInterfaces;
    private final String vpcId;
    private final String subnetId;
    private final String securityGroupId;
    private final String accessType;
    private final String customerOwnedIpv4Pool;
    private final FailedReason failedReason;

    private Endpoint(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.outpostsId = builder.outpostsId;
        this.cidrBlock = builder.cidrBlock;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.networkInterfaces = builder.networkInterfaces;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.securityGroupId = builder.securityGroupId;
        this.accessType = builder.accessType;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.failedReason = builder.failedReason;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final String outpostsId() {
        return this.outpostsId;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final EndpointStatus status() {
        return EndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String securityGroupId() {
        return this.securityGroupId;
    }

    public final EndpointAccessType accessType() {
        return EndpointAccessType.fromValue(this.accessType);
    }

    public final String accessTypeAsString() {
        return this.accessType;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public final FailedReason failedReason() {
        return this.failedReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.outpostsId(), other.outpostsId()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.securityGroupId(), other.securityGroupId()) && Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool()) && Objects.equals(this.failedReason(), other.failedReason());
    }

    public final String toString() {
        return ToString.builder((String)"Endpoint").add("EndpointArn", (Object)this.endpointArn()).add("OutpostsId", (Object)this.outpostsId()).add("CidrBlock", (Object)this.cidrBlock()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("VpcId", (Object)this.vpcId()).add("SubnetId", (Object)this.subnetId()).add("SecurityGroupId", (Object)this.securityGroupId()).add("AccessType", (Object)this.accessTypeAsString()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).add("FailedReason", (Object)this.failedReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "OutpostsId": {
                return Optional.ofNullable(clazz.cast(this.outpostsId()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.securityGroupId()));
            }
            case "AccessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
            case "FailedReason": {
                return Optional.ofNullable(clazz.cast(this.failedReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointArn;
        private String outpostsId;
        private String cidrBlock;
        private String status;
        private Instant creationTime;
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private String subnetId;
        private String securityGroupId;
        private String accessType;
        private String customerOwnedIpv4Pool;
        private FailedReason failedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.endpointArn(model.endpointArn);
            this.outpostsId(model.outpostsId);
            this.cidrBlock(model.cidrBlock);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.networkInterfaces(model.networkInterfaces);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.securityGroupId(model.securityGroupId);
            this.accessType(model.accessType);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            this.failedReason(model.failedReason);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getOutpostsId() {
            return this.outpostsId;
        }

        public final void setOutpostsId(String outpostsId) {
            this.outpostsId = outpostsId;
        }

        @Override
        public final Builder outpostsId(String outpostsId) {
            this.outpostsId = outpostsId;
            return this;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public final void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @Override
        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        public final String getAccessType() {
            return this.accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(EndpointAccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final FailedReason.Builder getFailedReason() {
            return this.failedReason != null ? this.failedReason.toBuilder() : null;
        }

        public final void setFailedReason(FailedReason.BuilderImpl failedReason) {
            this.failedReason = failedReason != null ? failedReason.build() : null;
        }

        @Override
        public final Builder failedReason(FailedReason failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Endpoint> {
        public Builder endpointArn(String var1);

        public Builder outpostsId(String var1);

        public Builder cidrBlock(String var1);

        public Builder status(String var1);

        public Builder status(EndpointStatus var1);

        public Builder creationTime(Instant var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder securityGroupId(String var1);

        public Builder accessType(String var1);

        public Builder accessType(EndpointAccessType var1);

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder failedReason(FailedReason var1);

        default public Builder failedReason(Consumer<FailedReason.Builder> failedReason) {
            return this.failedReason((FailedReason)((FailedReason.Builder)FailedReason.builder().applyMutation(failedReason)).build());
        }
    }
}

