/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3outposts.DefaultS3OutpostsAsyncClient;
import software.amazon.awssdk.services.s3outposts.DefaultS3OutpostsBaseClientBuilder;
import software.amazon.awssdk.services.s3outposts.S3OutpostsAsyncClient;
import software.amazon.awssdk.services.s3outposts.S3OutpostsAsyncClientBuilder;
import software.amazon.awssdk.services.s3outposts.S3OutpostsServiceClientConfiguration;
import software.amazon.awssdk.services.s3outposts.endpoints.S3OutpostsEndpointProvider;

@SdkInternalApi
final class DefaultS3OutpostsAsyncClientBuilder
extends DefaultS3OutpostsBaseClientBuilder<S3OutpostsAsyncClientBuilder, S3OutpostsAsyncClient>
implements S3OutpostsAsyncClientBuilder {
    DefaultS3OutpostsAsyncClientBuilder() {
    }

    @Override
    public DefaultS3OutpostsAsyncClientBuilder endpointProvider(S3OutpostsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final S3OutpostsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultS3OutpostsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        S3OutpostsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultS3OutpostsAsyncClient client = new DefaultS3OutpostsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private S3OutpostsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return S3OutpostsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

