/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3outposts.S3OutpostsAsyncClient;
import software.amazon.awssdk.services.s3outposts.model.Endpoint;
import software.amazon.awssdk.services.s3outposts.model.ListSharedEndpointsRequest;
import software.amazon.awssdk.services.s3outposts.model.ListSharedEndpointsResponse;

public class ListSharedEndpointsPublisher
implements SdkPublisher<ListSharedEndpointsResponse> {
    private final S3OutpostsAsyncClient client;
    private final ListSharedEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSharedEndpointsPublisher(S3OutpostsAsyncClient client, ListSharedEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSharedEndpointsPublisher(S3OutpostsAsyncClient client, ListSharedEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSharedEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSharedEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Endpoint> endpoints() {
        Function<ListSharedEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSharedEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSharedEndpointsResponseFetcher
    implements AsyncPageFetcher<ListSharedEndpointsResponse> {
        private ListSharedEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListSharedEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSharedEndpointsResponse> nextPage(ListSharedEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListSharedEndpointsPublisher.this.client.listSharedEndpoints(ListSharedEndpointsPublisher.this.firstRequest);
            }
            return ListSharedEndpointsPublisher.this.client.listSharedEndpoints((ListSharedEndpointsRequest)((Object)ListSharedEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

