/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OperationName {
    LAMBDA_INVOKE("LambdaInvoke"),
    S3_PUT_OBJECT_COPY("S3PutObjectCopy"),
    S3_PUT_OBJECT_ACL("S3PutObjectAcl"),
    S3_PUT_OBJECT_TAGGING("S3PutObjectTagging"),
    S3_INITIATE_RESTORE_OBJECT("S3InitiateRestoreObject"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OperationName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OperationName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationName> knownValues() {
        return Stream.of(OperationName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

