/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputeObjectChecksumAlgorithm {
    CRC32("CRC32"),
    CRC32_C("CRC32C"),
    CRC64_NVME("CRC64NVME"),
    MD5("MD5"),
    SHA1("SHA1"),
    SHA256("SHA256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputeObjectChecksumAlgorithm> VALUE_MAP;
    private final String value;

    private ComputeObjectChecksumAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputeObjectChecksumAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputeObjectChecksumAlgorithm> knownValues() {
        EnumSet<ComputeObjectChecksumAlgorithm> knownValues = EnumSet.allOf(ComputeObjectChecksumAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputeObjectChecksumAlgorithm.class, ComputeObjectChecksumAlgorithm::toString);
    }
}

