/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.s3control.auth.scheme.S3ControlAuthSchemeParams;
import software.amazon.awssdk.services.s3control.auth.scheme.internal.DefaultS3ControlAuthSchemeProvider;
import software.amazon.awssdk.services.s3control.auth.scheme.internal.PreferredS3ControlAuthSchemeProvider;

@SdkPublicApi
public interface S3ControlAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(S3ControlAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<S3ControlAuthSchemeParams.Builder> consumer) {
        S3ControlAuthSchemeParams.Builder builder = S3ControlAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static S3ControlAuthSchemeProvider defaultProvider() {
        return DefaultS3ControlAuthSchemeProvider.create();
    }

    public static S3ControlAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredS3ControlAuthSchemeProvider(S3ControlAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

