/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.StorageLensGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStorageLensGroupRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, UpdateStorageLensGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateStorageLensGroupRequest.getter(UpdateStorageLensGroupRequest::name)).setter(UpdateStorageLensGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(UpdateStorageLensGroupRequest.getter(UpdateStorageLensGroupRequest::accountId)).setter(UpdateStorageLensGroupRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<StorageLensGroup> STORAGE_LENS_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageLensGroup").getter(UpdateStorageLensGroupRequest.getter(UpdateStorageLensGroupRequest::storageLensGroup)).setter(UpdateStorageLensGroupRequest.setter(Builder::storageLensGroup)).constructor(StorageLensGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroup").unmarshallLocationName("StorageLensGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACCOUNT_ID_FIELD, STORAGE_LENS_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateStorageLensGroupRequest.memberNameToFieldInitializer();
    private final String name;
    private final String accountId;
    private final StorageLensGroup storageLensGroup;

    private UpdateStorageLensGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.accountId = builder.accountId;
        this.storageLensGroup = builder.storageLensGroup;
    }

    public final String name() {
        return this.name;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final StorageLensGroup storageLensGroup() {
        return this.storageLensGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLensGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageLensGroupRequest)) {
            return false;
        }
        UpdateStorageLensGroupRequest other = (UpdateStorageLensGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.storageLensGroup(), other.storageLensGroup());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStorageLensGroupRequest").add("Name", (Object)this.name()).add("AccountId", (Object)this.accountId()).add("StorageLensGroup", (Object)this.storageLensGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "StorageLensGroup": {
                return Optional.ofNullable(clazz.cast(this.storageLensGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("StorageLensGroup", STORAGE_LENS_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStorageLensGroupRequest, T> g) {
        return obj -> g.apply((UpdateStorageLensGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String name;
        private String accountId;
        private StorageLensGroup storageLensGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStorageLensGroupRequest model) {
            super(model);
            this.name(model.name);
            this.accountId(model.accountId);
            this.storageLensGroup(model.storageLensGroup);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final StorageLensGroup.Builder getStorageLensGroup() {
            return this.storageLensGroup != null ? this.storageLensGroup.toBuilder() : null;
        }

        public final void setStorageLensGroup(StorageLensGroup.BuilderImpl storageLensGroup) {
            this.storageLensGroup = storageLensGroup != null ? storageLensGroup.build() : null;
        }

        @Override
        public final Builder storageLensGroup(StorageLensGroup storageLensGroup) {
            this.storageLensGroup = storageLensGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStorageLensGroupRequest build() {
            return new UpdateStorageLensGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStorageLensGroupRequest> {
        public Builder name(String var1);

        public Builder accountId(String var1);

        public Builder storageLensGroup(StorageLensGroup var1);

        default public Builder storageLensGroup(Consumer<StorageLensGroup.Builder> storageLensGroup) {
            return this.storageLensGroup((StorageLensGroup)((StorageLensGroup.Builder)StorageLensGroup.builder().applyMutation(storageLensGroup)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

