/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.JobProgressSummary;
import software.amazon.awssdk.services.s3control.model.JobStatus;
import software.amazon.awssdk.services.s3control.model.OperationName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobListDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobListDescriptor> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(JobListDescriptor.getter(JobListDescriptor::jobId)).setter(JobListDescriptor.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").unmarshallLocationName("JobId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(JobListDescriptor.getter(JobListDescriptor::description)).setter(JobListDescriptor.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(JobListDescriptor.getter(JobListDescriptor::operationAsString)).setter(JobListDescriptor.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").unmarshallLocationName("Operation").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(JobListDescriptor.getter(JobListDescriptor::priority)).setter(JobListDescriptor.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("Priority").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(JobListDescriptor.getter(JobListDescriptor::statusAsString)).setter(JobListDescriptor.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(JobListDescriptor.getter(JobListDescriptor::creationTime)).setter(JobListDescriptor.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TERMINATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TerminationDate").getter(JobListDescriptor.getter(JobListDescriptor::terminationDate)).setter(JobListDescriptor.setter(Builder::terminationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationDate").unmarshallLocationName("TerminationDate").build()}).build();
    private static final SdkField<JobProgressSummary> PROGRESS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressSummary").getter(JobListDescriptor.getter(JobListDescriptor::progressSummary)).setter(JobListDescriptor.setter(Builder::progressSummary)).constructor(JobProgressSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressSummary").unmarshallLocationName("ProgressSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, DESCRIPTION_FIELD, OPERATION_FIELD, PRIORITY_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, TERMINATION_DATE_FIELD, PROGRESS_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobListDescriptor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String description;
    private final String operation;
    private final Integer priority;
    private final String status;
    private final Instant creationTime;
    private final Instant terminationDate;
    private final JobProgressSummary progressSummary;

    private JobListDescriptor(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.description = builder.description;
        this.operation = builder.operation;
        this.priority = builder.priority;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.terminationDate = builder.terminationDate;
        this.progressSummary = builder.progressSummary;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String description() {
        return this.description;
    }

    public final OperationName operation() {
        return OperationName.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant terminationDate() {
        return this.terminationDate;
    }

    public final JobProgressSummary progressSummary() {
        return this.progressSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobListDescriptor)) {
            return false;
        }
        JobListDescriptor other = (JobListDescriptor)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.terminationDate(), other.terminationDate()) && Objects.equals(this.progressSummary(), other.progressSummary());
    }

    public final String toString() {
        return ToString.builder((String)"JobListDescriptor").add("JobId", (Object)this.jobId()).add("Description", (Object)this.description()).add("Operation", (Object)this.operationAsString()).add("Priority", (Object)this.priority()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("TerminationDate", (Object)this.terminationDate()).add("ProgressSummary", (Object)this.progressSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TerminationDate": {
                return Optional.ofNullable(clazz.cast(this.terminationDate()));
            }
            case "ProgressSummary": {
                return Optional.ofNullable(clazz.cast(this.progressSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("TerminationDate", TERMINATION_DATE_FIELD);
        map.put("ProgressSummary", PROGRESS_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobListDescriptor, T> g) {
        return obj -> g.apply((JobListDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String description;
        private String operation;
        private Integer priority;
        private String status;
        private Instant creationTime;
        private Instant terminationDate;
        private JobProgressSummary progressSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(JobListDescriptor model) {
            this.jobId(model.jobId);
            this.description(model.description);
            this.operation(model.operation);
            this.priority(model.priority);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.terminationDate(model.terminationDate);
            this.progressSummary(model.progressSummary);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(OperationName operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTerminationDate() {
            return this.terminationDate;
        }

        public final void setTerminationDate(Instant terminationDate) {
            this.terminationDate = terminationDate;
        }

        @Override
        public final Builder terminationDate(Instant terminationDate) {
            this.terminationDate = terminationDate;
            return this;
        }

        public final JobProgressSummary.Builder getProgressSummary() {
            return this.progressSummary != null ? this.progressSummary.toBuilder() : null;
        }

        public final void setProgressSummary(JobProgressSummary.BuilderImpl progressSummary) {
            this.progressSummary = progressSummary != null ? progressSummary.build() : null;
        }

        @Override
        public final Builder progressSummary(JobProgressSummary progressSummary) {
            this.progressSummary = progressSummary;
            return this;
        }

        public JobListDescriptor build() {
            return new JobListDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobListDescriptor> {
        public Builder jobId(String var1);

        public Builder description(String var1);

        public Builder operation(String var1);

        public Builder operation(OperationName var1);

        public Builder priority(Integer var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder terminationDate(Instant var1);

        public Builder progressSummary(JobProgressSummary var1);

        default public Builder progressSummary(Consumer<JobProgressSummary.Builder> progressSummary) {
            return this.progressSummary((JobProgressSummary)((JobProgressSummary.Builder)JobProgressSummary.builder().applyMutation(progressSummary)).build());
        }
    }
}

